/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.rs.security.jose.common.JoseException;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesWrapKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.PbesHmacAesWrapKeyEncryptionAlgorithm;

public class PbesHmacAesWrapKeyDecryptionAlgorithm
implements KeyDecryptionProvider {
    private byte[] password;
    private KeyAlgorithm algo;

    public PbesHmacAesWrapKeyDecryptionAlgorithm(String password) {
        this(password, KeyAlgorithm.PBES2_HS256_A128KW, false);
    }

    public PbesHmacAesWrapKeyDecryptionAlgorithm(String password, KeyAlgorithm algo, boolean hashLargePasswords) {
        this(PbesHmacAesWrapKeyEncryptionAlgorithm.stringToBytes(password), algo, hashLargePasswords);
    }

    public PbesHmacAesWrapKeyDecryptionAlgorithm(char[] password) {
        this(password, KeyAlgorithm.PBES2_HS256_A128KW, false);
    }

    public PbesHmacAesWrapKeyDecryptionAlgorithm(char[] password, KeyAlgorithm algo, boolean hashLargePasswords) {
        this(PbesHmacAesWrapKeyEncryptionAlgorithm.charsToBytes(password), algo, hashLargePasswords);
    }

    public PbesHmacAesWrapKeyDecryptionAlgorithm(byte[] password) {
        this(password, KeyAlgorithm.PBES2_HS256_A128KW, false);
    }

    public PbesHmacAesWrapKeyDecryptionAlgorithm(byte[] password, KeyAlgorithm algo, boolean hashLargePasswords) {
        this.password = PbesHmacAesWrapKeyEncryptionAlgorithm.validatePassword(password, algo.getJwaName(), hashLargePasswords);
        this.algo = algo;
    }

    @Override
    public byte[] getDecryptedContentEncryptionKey(JweDecryptionInput jweDecryptionInput) {
        JweHeaders jweHeaders = jweDecryptionInput.getJweHeaders();
        byte[] saltInput = this.getDecodedBytes(jweHeaders.getHeader("p2s"));
        int pbesCount = jweHeaders.getIntegerHeader("p2c");
        String keyAlgoJwt = jweHeaders.getKeyEncryptionAlgorithm().getJwaName();
        int keySize = PbesHmacAesWrapKeyEncryptionAlgorithm.getKeySize(keyAlgoJwt);
        byte[] derivedKey = PbesHmacAesWrapKeyEncryptionAlgorithm.createDerivedKey(keyAlgoJwt, keySize, this.password, saltInput, pbesCount);
        AesWrapKeyDecryptionAlgorithm aesWrap = new AesWrapKeyDecryptionAlgorithm(derivedKey, this.algo){

            @Override
            protected boolean isValidAlgorithmFamily(String wrapAlgo) {
                return AlgorithmUtils.isPbesHsWrap(wrapAlgo);
            }
        };
        return aesWrap.getDecryptedContentEncryptionKey(jweDecryptionInput);
    }

    private byte[] getDecodedBytes(Object p2sHeader) {
        try {
            return Base64UrlUtility.decode((String)p2sHeader.toString());
        }
        catch (Exception ex) {
            throw new JoseException(ex);
        }
    }

    @Override
    public KeyAlgorithm getAlgorithm() {
        return this.algo;
    }
}

