/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.interfaces.ECPrivateKey;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesWrapKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;

public class EcdhAesWrapKeyDecryptionAlgorithm
implements KeyDecryptionProvider {
    private final ECPrivateKey key;
    private final KeyAlgorithm algo;

    public EcdhAesWrapKeyDecryptionAlgorithm(ECPrivateKey key) {
        this(key, KeyAlgorithm.ECDH_ES_A128KW);
    }

    public EcdhAesWrapKeyDecryptionAlgorithm(ECPrivateKey key, KeyAlgorithm algo) {
        this.key = key;
        this.algo = algo;
    }

    @Override
    public byte[] getDecryptedContentEncryptionKey(JweDecryptionInput jweDecryptionInput) {
        byte[] derivedKey = this.getDecryptedContentEncryptionKeyFromHeaders(jweDecryptionInput.getJweHeaders(), this.key);
        AesWrapKeyDecryptionAlgorithm aesWrap = new AesWrapKeyDecryptionAlgorithm(derivedKey, KeyAlgorithm.ECDH_ES_A128KW){

            @Override
            protected boolean isValidAlgorithmFamily(String wrapAlgo) {
                return AlgorithmUtils.isEcdhEsWrap(wrapAlgo);
            }
        };
        return aesWrap.getDecryptedContentEncryptionKey(jweDecryptionInput);
    }

    @Override
    public KeyAlgorithm getAlgorithm() {
        return this.algo;
    }

    protected byte[] getDecryptedContentEncryptionKeyFromHeaders(JweHeaders headers, ECPrivateKey privateKey) {
        KeyAlgorithm jwtAlgo = headers.getKeyEncryptionAlgorithm();
        JsonWebKey publicJwk = headers.getJsonWebKey("epk");
        String apuHeader = (String)headers.getHeader("apu");
        byte[] apuBytes = apuHeader == null ? null : JoseUtils.decode(apuHeader);
        String apvHeader = (String)headers.getHeader("apv");
        byte[] apvBytes = apvHeader == null ? null : JoseUtils.decode(apvHeader);
        return JweUtils.getECDHKey(privateKey, JwkUtils.toECPublicKey(publicJwk), apuBytes, apvBytes, jwtAlgo.getJwaName(), jwtAlgo.getKeySizeBits());
    }
}

