/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionProvider;
import org.apache.cxf.rt.security.crypto.CryptoUtils;
import org.apache.cxf.rt.security.crypto.KeyProperties;

public abstract class AbstractWrapKeyEncryptionAlgorithm
implements KeyEncryptionProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractWrapKeyEncryptionAlgorithm.class);
    private final Key keyEncryptionKey;
    private final boolean wrap;
    private final KeyAlgorithm algorithm;
    private final Set<String> supportedAlgorithms;

    protected AbstractWrapKeyEncryptionAlgorithm(Key key, Set<String> supportedAlgorithms) {
        this(key, null, true, supportedAlgorithms);
    }

    protected AbstractWrapKeyEncryptionAlgorithm(Key key, boolean wrap, Set<String> supportedAlgorithms) {
        this(key, null, wrap, supportedAlgorithms);
    }

    protected AbstractWrapKeyEncryptionAlgorithm(Key key, KeyAlgorithm jweAlgo, Set<String> supportedAlgorithms) {
        this(key, jweAlgo, true, supportedAlgorithms);
    }

    protected AbstractWrapKeyEncryptionAlgorithm(Key key, KeyAlgorithm jweAlgo, boolean wrap, Set<String> supportedAlgorithms) {
        this.keyEncryptionKey = key;
        this.algorithm = jweAlgo;
        this.wrap = wrap;
        this.supportedAlgorithms = supportedAlgorithms;
    }

    @Override
    public KeyAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] getEncryptedContentEncryptionKey(JweHeaders headers, byte[] cek) {
        this.checkAlgorithms(headers);
        KeyProperties secretKeyProperties = new KeyProperties(this.getKeyEncryptionAlgoJava(headers));
        AlgorithmParameterSpec spec = this.getAlgorithmParameterSpec(headers);
        if (spec != null) {
            secretKeyProperties.setAlgoSpec(spec);
        }
        if (!this.wrap) {
            return CryptoUtils.encryptBytes((byte[])cek, (Key)this.keyEncryptionKey, (KeyProperties)secretKeyProperties);
        }
        return CryptoUtils.wrapSecretKey((byte[])cek, (String)this.getContentEncryptionAlgoJava(headers), (Key)this.keyEncryptionKey, (KeyProperties)secretKeyProperties);
    }

    protected String getKeyEncryptionAlgoJava(JweHeaders headers) {
        return AlgorithmUtils.toJavaName(headers.getKeyEncryptionAlgorithm().getJwaName());
    }

    protected String getContentEncryptionAlgoJava(JweHeaders headers) {
        return AlgorithmUtils.toJavaName(headers.getContentEncryptionAlgorithm().getJwaName());
    }

    protected AlgorithmParameterSpec getAlgorithmParameterSpec(JweHeaders headers) {
        return null;
    }

    protected String checkAlgorithm(String algo) {
        if (algo != null && !this.supportedAlgorithms.contains(algo)) {
            LOG.warning("Invalid key encryption algorithm: " + algo);
            throw new JweException(JweException.Error.INVALID_KEY_ALGORITHM);
        }
        return algo;
    }

    protected void checkAlgorithms(JweHeaders headers) {
        KeyAlgorithm providedAlgo = headers.getKeyEncryptionAlgorithm();
        if (providedAlgo != null && !providedAlgo.equals((Object)this.algorithm)) {
            LOG.warning("Invalid key encryption algorithm: " + String.valueOf((Object)providedAlgo));
            throw new JweException(JweException.Error.INVALID_KEY_ALGORITHM);
        }
        if (providedAlgo != null) {
            this.checkAlgorithm(providedAlgo.getJwaName());
        } else {
            this.checkAlgorithm(this.algorithm.getJwaName());
            headers.setKeyEncryptionAlgorithm(this.algorithm);
        }
    }
}

