/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthValidator;
import net.oauth.server.OAuthServlet;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.rs.security.oauth.data.Client;
import org.apache.cxf.rs.security.oauth.data.RequestToken;
import org.apache.cxf.rs.security.oauth.data.Token;
import org.apache.cxf.rs.security.oauth.provider.DefaultOAuthValidator;
import org.apache.cxf.rs.security.oauth.provider.OAuthDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OAuthUtils {
    public static final String REPORT_FAILURE_DETAILS = "report.failure.details";
    public static final String REPORT_FAILURE_DETAILS_AS_HEADER = "report.failure.details.as.header";

    private OAuthUtils() {
    }

    public static boolean checkRequestURI(String servletPath, String uri) {
        boolean wildcard = uri.endsWith("*");
        String theURI = wildcard ? uri.substring(0, uri.length() - 1) : uri;
        try {
            URITemplate template = new URITemplate(theURI);
            MetadataMap map = new MetadataMap();
            if (template.match(servletPath, (MultivaluedMap)map)) {
                String finalGroup = (String)map.getFirst((Object)"FINAL_MATCH_GROUP");
                if (wildcard || StringUtils.isEmpty((String)finalGroup) || "/".equals(finalGroup)) {
                    return true;
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return false;
    }

    public static void validateMessage(OAuthMessage oAuthMessage, Client client, Token token, OAuthDataProvider provider, OAuthValidator validator) throws Exception {
        OAuthConsumer consumer = new OAuthConsumer(null, client.getConsumerKey(), client.getSecretKey(), null);
        OAuthAccessor accessor = new OAuthAccessor(consumer);
        if (token != null) {
            if (token instanceof RequestToken) {
                accessor.requestToken = token.getTokenKey();
            } else {
                accessor.accessToken = token.getTokenKey();
            }
            accessor.tokenSecret = token.getTokenSecret();
        }
        try {
            validator.validateMessage(oAuthMessage, accessor);
        }
        catch (Exception ex) {
            if (token != null) {
                provider.removeToken(token);
            }
            throw ex;
        }
        if (token != null && validator instanceof DefaultOAuthValidator) {
            ((DefaultOAuthValidator)validator).validateToken(token, provider);
        }
    }

    public static OAuthMessage getOAuthMessage(MessageContext mc, HttpServletRequest request, String[] requiredParams) throws Exception {
        OAuthMessage oAuthMessage = OAuthServlet.getMessage((HttpServletRequest)request, (String)request.getRequestURL().toString());
        OAuthUtils.addParametersIfNeeded(mc, request, oAuthMessage);
        oAuthMessage.requireParameters(requiredParams);
        return oAuthMessage;
    }

    public static void addParametersIfNeeded(MessageContext mc, HttpServletRequest request, OAuthMessage oAuthMessage) throws IOException {
        List params = oAuthMessage.getParameters();
        String enc = oAuthMessage.getBodyEncoding();
        String string = enc = enc == null ? "UTF-8" : enc;
        if (params.isEmpty() && "application/x-www-form-urlencoded".equals(oAuthMessage.getBodyType())) {
            InputStream stream = mc != null ? (InputStream)mc.getContent(InputStream.class) : oAuthMessage.getBodyAsStream();
            String body = FormUtils.readBody((InputStream)stream, (String)enc);
            MetadataMap map = new MetadataMap();
            FormUtils.populateMapFromString((MultivaluedMap)map, (Message)PhaseInterceptorChain.getCurrentMessage(), (String)body, (String)enc, (boolean)true, (HttpServletRequest)request);
            for (String key : map.keySet()) {
                oAuthMessage.addParameter(key, (String)map.getFirst((Object)key));
            }
        } else {
            String ct = request.getContentType();
            if (ct != null && "application/x-www-form-urlencoded".equals(ct)) {
                HashMap map = new HashMap();
                for (Map.Entry param : params) {
                    map.put(param.getKey(), Collections.singletonList(param.getValue()));
                }
                FormUtils.logRequestParametersIfNeeded(map, (String)enc);
            }
        }
    }

    public static Response handleException(MessageContext mc, Exception e, int status) {
        Response.ResponseBuilder builder = Response.status((int)status);
        if (MessageUtils.isTrue((Object)mc.getContextualProperty((Object)REPORT_FAILURE_DETAILS))) {
            boolean asHeader = MessageUtils.isTrue((Object)mc.getContextualProperty((Object)REPORT_FAILURE_DETAILS_AS_HEADER));
            String text = null;
            if (e instanceof OAuthProblemException) {
                OAuthProblemException problem = (OAuthProblemException)((Object)e);
                if (asHeader && problem.getProblem() != null) {
                    text = problem.getProblem();
                }
            }
            if (text == null) {
                text = e.getMessage();
            }
            if (asHeader) {
                builder.header("oauth_problem", (Object)text);
            } else {
                builder.entity((Object)e.getMessage());
            }
        }
        throw new WebApplicationException(builder.build());
    }

    public static List<String> parseParamValue(String paramValue, String defaultValue) throws IOException {
        ArrayList<String> scopeList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)paramValue)) {
            StringTokenizer tokenizer = new StringTokenizer(paramValue, " ");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                scopeList.add(token);
            }
        }
        if (defaultValue != null && !scopeList.contains(defaultValue)) {
            scopeList.add(defaultValue);
        }
        return scopeList;
    }

    public static RequestToken handleTokenRejectedException() throws OAuthProblemException {
        OAuthProblemException problemEx = new OAuthProblemException("token_rejected");
        problemEx.setParameter("HTTP status", (Object)401);
        throw problemEx;
    }

    public static Object instantiateClass(String className) throws Exception {
        Class clazz = ClassLoaderUtils.loadClass((String)className, OAuthUtils.class);
        return clazz.newInstance();
    }

    public static synchronized OAuthDataProvider getOAuthDataProvider(OAuthDataProvider provider, ServletContext servletContext) {
        if (provider != null) {
            return provider;
        }
        return OAuthUtils.getOAuthDataProvider(servletContext);
    }

    public static synchronized OAuthDataProvider getOAuthDataProvider(ServletContext servletContext) {
        OAuthDataProvider dataProvider = (OAuthDataProvider)servletContext.getAttribute("oauth.data.provider-instance.key");
        if (dataProvider == null) {
            String dataProviderClassName = servletContext.getInitParameter("oauth.data.provider-class");
            if (StringUtils.isEmpty((String)dataProviderClassName)) {
                throw new RuntimeException("There should be provided [ oauth.data.provider-class ] context init param in web.xml");
            }
            try {
                dataProvider = (OAuthDataProvider)OAuthUtils.instantiateClass(dataProviderClassName);
                servletContext.setAttribute("oauth.data.provider-instance.key", (Object)dataProvider);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot instantiate OAuth Data Provider class: " + dataProviderClassName, e);
            }
        }
        return dataProvider;
    }

    public static synchronized OAuthValidator getOAuthValidator(ServletContext servletContext) {
        String dataProviderClassName;
        OAuthValidator dataProvider = (OAuthValidator)servletContext.getAttribute("oauth.data.validator-instance.key");
        if (dataProvider == null && !StringUtils.isEmpty((String)(dataProviderClassName = servletContext.getInitParameter("oauth.data.validator-class")))) {
            try {
                dataProvider = (OAuthValidator)OAuthUtils.instantiateClass(dataProviderClassName);
                servletContext.setAttribute("oauth.data.validator-instance.key", (Object)dataProvider);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot instantiate OAuthValidator class: " + dataProviderClassName, e);
            }
        }
        return dataProvider == null ? new DefaultOAuthValidator() : dataProvider;
    }
}

