/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth.services;

import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth.data.AuthorizationInput;
import org.apache.cxf.rs.security.oauth.data.OAuthAuthorizationData;
import org.apache.cxf.rs.security.oauth.data.OAuthPermission;
import org.apache.cxf.rs.security.oauth.data.RequestToken;
import org.apache.cxf.rs.security.oauth.data.UserSubject;
import org.apache.cxf.rs.security.oauth.provider.DefaultOAuthValidator;
import org.apache.cxf.rs.security.oauth.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth.services.OOBAuthorizationResponse;
import org.apache.cxf.rs.security.oauth.utils.OAuthUtils;
import org.apache.cxf.security.LoginSecurityContext;
import org.apache.cxf.security.SecurityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationRequestHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(AuthorizationRequestHandler.class);
    private static final String[] REQUIRED_PARAMETERS = new String[]{"oauth_token"};

    public Response handle(MessageContext mc, OAuthDataProvider dataProvider) {
        HttpServletRequest request = mc.getHttpServletRequest();
        try {
            String callbackValue;
            OAuthMessage oAuthMessage = OAuthUtils.getOAuthMessage(mc, request, REQUIRED_PARAMETERS);
            new DefaultOAuthValidator().checkSingleParameter(oAuthMessage);
            RequestToken token = dataProvider.getRequestToken(oAuthMessage.getToken());
            if (token == null) {
                throw new OAuthProblemException("token_rejected");
            }
            String decision = oAuthMessage.getParameter("oauthDecision");
            OAuthAuthorizationData secData = new OAuthAuthorizationData();
            if (!this.compareRequestSessionTokens(request, oAuthMessage)) {
                if (decision != null) {
                    LOG.warning("Session authenticity token is missing or invalid");
                    throw new WebApplicationException(400);
                }
                this.addAuthenticityTokenToSession(secData, request);
                return Response.ok((Object)this.addAdditionalParams(secData, dataProvider, token)).build();
            }
            boolean allow = "allow".equals(decision);
            HashMap<String, String> queryParams = new HashMap<String, String>();
            if (allow) {
                SecurityContext sc = (SecurityContext)mc.get((Object)SecurityContext.class.getName());
                List<String> roleNames = Collections.emptyList();
                if (sc instanceof LoginSecurityContext) {
                    roleNames = new ArrayList();
                    Set roles = ((LoginSecurityContext)sc).getUserRoles();
                    for (Principal p : roles) {
                        roleNames.add(p.getName());
                    }
                }
                token.setSubject(new UserSubject(sc.getUserPrincipal() == null ? null : sc.getUserPrincipal().getName(), roleNames));
                AuthorizationInput input = new AuthorizationInput();
                input.setToken(token);
                HashSet<OAuthPermission> approvedScopesSet = new HashSet<OAuthPermission>();
                List<OAuthPermission> originalScopes = token.getScopes();
                for (OAuthPermission perm : originalScopes) {
                    String param = oAuthMessage.getParameter(perm.getPermission() + "_status");
                    if (param == null || !"allow".equals(param)) continue;
                    approvedScopesSet.add(perm);
                }
                List<Object> approvedScopes = new LinkedList(approvedScopesSet);
                if (approvedScopes.isEmpty()) {
                    approvedScopes = originalScopes;
                } else if (approvedScopes.size() < originalScopes.size()) {
                    for (OAuthPermission perm : originalScopes) {
                        if (!perm.isDefault() || approvedScopes.contains(perm)) continue;
                        approvedScopes.add(perm);
                    }
                }
                input.setApprovedScopes(approvedScopes);
                String verifier = dataProvider.finalizeAuthorization(input);
                queryParams.put("oauth_verifier", verifier);
            } else {
                dataProvider.removeToken(token);
            }
            queryParams.put("oauth_token", token.getTokenKey());
            if (token.getState() != null) {
                queryParams.put("state", token.getState());
            }
            if ("oob".equals(callbackValue = this.getCallbackValue(token))) {
                OOBAuthorizationResponse bean = this.convertQueryParamsToOOB(queryParams);
                return Response.ok().entity((Object)bean).build();
            }
            URI callbackURI = this.buildCallbackURI(callbackValue, queryParams);
            return Response.seeOther((URI)callbackURI).build();
        }
        catch (OAuthProblemException e) {
            LOG.log(Level.WARNING, "An OAuth related problem: {0}", new Object[]{e.fillInStackTrace()});
            int code = e.getHttpStatusCode();
            if (code == 200) {
                code = e.getProblem() == "consumer_key_unknown" ? 401 : 400;
            }
            return OAuthUtils.handleException(mc, (Exception)((Object)e), code);
        }
        catch (OAuthServiceException e) {
            return OAuthUtils.handleException(mc, e, 400);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unexpected internal server exception: {0}", new Object[]{e.fillInStackTrace()});
            return OAuthUtils.handleException(mc, e, 500);
        }
    }

    protected String getCallbackValue(RequestToken token) throws OAuthProblemException {
        String callback = token.getCallback();
        if (callback == null) {
            callback = token.getClient().getApplicationURI();
        }
        if (callback == null) {
            throw new OAuthProblemException("token_rejected");
        }
        return callback;
    }

    private URI buildCallbackURI(String callback, Map<String, String> queryParams) {
        UriBuilder builder = UriBuilder.fromUri((String)callback);
        for (Map.Entry<String, String> entry : queryParams.entrySet()) {
            builder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
        }
        return builder.build(new Object[0]);
    }

    private OOBAuthorizationResponse convertQueryParamsToOOB(Map<String, String> queryParams) {
        OOBAuthorizationResponse oob = new OOBAuthorizationResponse();
        oob.setRequestToken(queryParams.get("oauth_token"));
        oob.setVerifier(queryParams.get("oauth_verifier"));
        oob.setState(queryParams.get("state"));
        return oob;
    }

    protected OAuthAuthorizationData addAdditionalParams(OAuthAuthorizationData secData, OAuthDataProvider dataProvider, RequestToken token) throws OAuthProblemException {
        secData.setOauthToken(token.getTokenKey());
        secData.setApplicationName(token.getClient().getApplicationName());
        secData.setApplicationURI(token.getClient().getApplicationURI());
        secData.setCallbackURI(this.getCallbackValue(token));
        secData.setApplicationDescription(token.getClient().getApplicationDescription());
        secData.setLogoUri(token.getClient().getLogoUri());
        secData.setPermissions(token.getScopes());
        return secData;
    }

    private void addAuthenticityTokenToSession(OAuthAuthorizationData secData, HttpServletRequest request) {
        HttpSession session = request.getSession();
        String value = UUID.randomUUID().toString();
        secData.setAuthenticityToken(value);
        session.setAttribute("session_authenticity_token", (Object)value);
    }

    private boolean compareRequestSessionTokens(HttpServletRequest request, OAuthMessage oAuthMessage) {
        HttpSession session = request.getSession();
        String requestToken = null;
        try {
            requestToken = oAuthMessage.getParameter("session_authenticity_token");
        }
        catch (IOException ex) {
            return false;
        }
        String sessionToken = (String)session.getAttribute("session_authenticity_token");
        if (StringUtils.isEmpty((String)requestToken) || StringUtils.isEmpty((String)sessionToken)) {
            return false;
        }
        boolean b = requestToken.equals(sessionToken);
        session.removeAttribute("session_authenticity_token");
        return b;
    }
}

