/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.auth.saml;

import java.io.ByteArrayInputStream;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.oauth2.saml.SamlOAuthValidator;
import org.apache.cxf.rs.security.oauth2.utils.Base64UrlUtility;
import org.apache.cxf.rs.security.saml.AbstractSamlInHandler;
import org.apache.cxf.rs.security.saml.SAMLUtils;
import org.apache.cxf.rs.security.saml.assertion.Subject;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.w3c.dom.Element;

public class Saml2BearerAuthHandler
extends AbstractSamlInHandler {
    private FormEncodingProvider<Form> provider = new FormEncodingProvider(true);
    private SamlOAuthValidator samlOAuthValidator = new SamlOAuthValidator();

    public void setSamlOAuthValidator(SamlOAuthValidator validator) {
        this.samlOAuthValidator = validator;
    }

    public void filter(ContainerRequestContext context) {
        String decodedAssertionType;
        Message message = JAXRSUtils.getCurrentMessage();
        Form form = this.readFormData(message);
        MultivaluedMap formData = form.asMap();
        String assertionType = (String)formData.getFirst((Object)"client_assertion_type");
        String string = decodedAssertionType = assertionType != null ? HttpUtils.urlDecode((String)assertionType) : null;
        if (decodedAssertionType == null || !"urn:ietf:params:oauth:client-assertion-type:saml2-bearer".equals(decodedAssertionType)) {
            throw new NotAuthorizedException(Saml2BearerAuthHandler.errorResponse());
        }
        String assertion = (String)formData.getFirst((Object)"client_assertion");
        Element token = this.readToken(message, assertion);
        String clientId = (String)formData.getFirst((Object)"client_id");
        this.validateToken(message, token, clientId);
        formData.remove((Object)"client_id");
        formData.remove((Object)"client_assertion");
        formData.remove((Object)"client_assertion_type");
        try {
            FormUtils.restoreForm(this.provider, (Form)form, (Message)message);
        }
        catch (Exception ex) {
            throw new NotAuthorizedException(Saml2BearerAuthHandler.errorResponse());
        }
    }

    private Form readFormData(Message message) {
        try {
            return FormUtils.readForm(this.provider, (Message)message);
        }
        catch (Exception ex) {
            throw new NotAuthorizedException(Saml2BearerAuthHandler.errorResponse());
        }
    }

    protected Element readToken(Message message, String assertion) {
        if (assertion == null) {
            throw new NotAuthorizedException(Saml2BearerAuthHandler.errorResponse());
        }
        try {
            byte[] deflatedToken = Base64UrlUtility.decode((String)assertion);
            ByteArrayInputStream is = new ByteArrayInputStream(deflatedToken);
            return this.readToken(message, is);
        }
        catch (Base64Exception ex) {
            throw new NotAuthorizedException(Saml2BearerAuthHandler.errorResponse());
        }
    }

    protected void validateToken(Message message, Element element, String clientId) {
        SamlAssertionWrapper wrapper = this.toWrapper(element);
        super.validateToken(message, wrapper);
        Subject subject = SAMLUtils.getSubject((Message)message, (SamlAssertionWrapper)wrapper);
        if (subject.getName() == null) {
            throw new NotAuthorizedException(Saml2BearerAuthHandler.errorResponse());
        }
        if (clientId != null && !clientId.equals(subject.getName())) {
            throw new NotAuthorizedException(Saml2BearerAuthHandler.errorResponse());
        }
        this.samlOAuthValidator.validate(message, wrapper);
        message.put((Object)"client_id", (Object)subject.getName());
    }

    private static Response errorResponse() {
        return Response.status((int)401).build();
    }
}

