/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.saml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.rs.security.common.CryptoLoader;
import org.apache.cxf.rs.security.common.SecurityUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.AbstractGrantHandler;
import org.apache.cxf.rs.security.oauth2.grants.saml.SamlUserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.saml.SamlOAuthValidator;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.rs.security.saml.authorization.SecurityContextProvider;
import org.apache.cxf.rs.security.saml.authorization.SecurityContextProviderImpl;
import org.apache.cxf.rt.security.saml.SAMLSecurityContext;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SAMLKeyInfoProcessor;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.saml.WSSSAMLKeyInfoProcessor;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.SamlAssertionValidator;
import org.apache.wss4j.dom.validate.Validator;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Saml2BearerGrantHandler
extends AbstractGrantHandler {
    private static final String ENCODED_SAML2_BEARER_GRANT;
    private Validator samlValidator = new SamlAssertionValidator();
    private SamlOAuthValidator samlOAuthValidator = new SamlOAuthValidator();
    private SecurityContextProvider scProvider = new SecurityContextProviderImpl();

    public Saml2BearerGrantHandler() {
        super(Arrays.asList("urn:ietf:params:oauth:grant-type:saml2-bearer", ENCODED_SAML2_BEARER_GRANT));
    }

    public void setSamlValidator(Validator validator) {
        this.samlValidator = validator;
    }

    public void setSamlOAuthValidator(SamlOAuthValidator validator) {
        this.samlOAuthValidator = validator;
    }

    public void setSecurityContextProvider(SecurityContextProvider p) {
        this.scProvider = p;
    }

    public ServerAccessToken createAccessToken(Client client, MultivaluedMap<String, String> params) throws OAuthServiceException {
        String assertion = (String)params.getFirst((Object)"assertion");
        if (assertion == null) {
            throw new OAuthServiceException("invalid_grant");
        }
        try {
            InputStream tokenStream = this.decodeAssertion(assertion);
            Element token = this.readToken(tokenStream);
            SamlAssertionWrapper assertionWrapper = new SamlAssertionWrapper(token);
            Message message = PhaseInterceptorChain.getCurrentMessage();
            this.validateToken(message, assertionWrapper);
            UserSubject grantSubject = this.getGrantSubject(message, assertionWrapper);
            return this.doCreateAccessToken(client, grantSubject, "urn:ietf:params:oauth:grant-type:saml2-bearer", OAuthUtils.parseScope((String)((String)params.getFirst((Object)"scope"))));
        }
        catch (OAuthServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OAuthServiceException("invalid_grant", (Throwable)ex);
        }
    }

    protected UserSubject getGrantSubject(Message message, SamlAssertionWrapper wrapper) {
        SecurityContext sc = this.scProvider.getSecurityContext(message, wrapper);
        if (sc instanceof SAMLSecurityContext) {
            SAMLSecurityContext jaxrsSc = (SAMLSecurityContext)sc;
            Set rolesP = jaxrsSc.getUserRoles();
            ArrayList<String> roles = new ArrayList<String>();
            if (roles != null) {
                for (Principal p : rolesP) {
                    roles.add(p.getName());
                }
            }
            return new SamlUserSubject(jaxrsSc.getUserPrincipal().getName(), roles, jaxrsSc.getClaims());
        }
        return new UserSubject(sc.getUserPrincipal().getName());
    }

    private InputStream decodeAssertion(String assertion) {
        try {
            byte[] deflatedToken = Base64UrlUtility.decode((String)assertion);
            return new ByteArrayInputStream(deflatedToken);
        }
        catch (Base64Exception ex) {
            throw new OAuthServiceException("invalid_grant");
        }
    }

    protected Element readToken(InputStream tokenStream) {
        try {
            Document doc = StaxUtils.read((Reader)new InputStreamReader(tokenStream, "UTF-8"));
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            throw new OAuthServiceException("invalid_grant");
        }
    }

    protected void validateToken(Message message, SamlAssertionWrapper assertion) {
        try {
            RequestData data = new RequestData();
            if (assertion.isSigned()) {
                WSSConfig cfg = WSSConfig.getNewInstance();
                data.setWssConfig(cfg);
                data.setCallbackHandler(SecurityUtils.getCallbackHandler((Message)message, ((Object)((Object)this)).getClass()));
                try {
                    data.setSigVerCrypto(new CryptoLoader().getCrypto(message, "ws-security.signature.crypto", "ws-security.signature.properties"));
                }
                catch (IOException ex) {
                    throw new OAuthServiceException("invalid_grant");
                }
                data.setEnableRevocation(MessageUtils.isTrue((Object)message.getContextualProperty("enableRevocation")));
                Signature sig = assertion.getSignature();
                WSDocInfo docInfo = new WSDocInfo(sig.getDOM().getOwnerDocument());
                KeyInfo keyInfo = sig.getKeyInfo();
                SAMLKeyInfo samlKeyInfo = SAMLUtil.getCredentialFromKeyInfo((Element)keyInfo.getDOM(), (SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(data, docInfo), (Crypto)data.getSigVerCrypto());
                assertion.verifySignature(samlKeyInfo);
                assertion.parseSubject((SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(data, null), data.getSigVerCrypto(), data.getCallbackHandler());
            } else if (this.getTLSCertificates(message) == null) {
                throw new OAuthServiceException("invalid_grant");
            }
            if (this.samlValidator != null) {
                Credential credential = new Credential();
                credential.setSamlAssertion(assertion);
                this.samlValidator.validate(credential, data);
            }
            this.samlOAuthValidator.validate(message, assertion);
        }
        catch (Exception ex) {
            throw new OAuthServiceException("invalid_grant", (Throwable)ex);
        }
    }

    private Certificate[] getTLSCertificates(Message message) {
        TLSSessionInfo tlsInfo = (TLSSessionInfo)message.get(TLSSessionInfo.class);
        return tlsInfo != null ? tlsInfo.getPeerCertificates() : null;
    }

    protected void setSecurityContext(Message message, SamlAssertionWrapper wrapper) {
        if (this.scProvider != null) {
            SecurityContext sc = this.scProvider.getSecurityContext(message, wrapper);
            message.put(SecurityContext.class, (Object)sc);
        }
    }

    static {
        WSSConfig.init();
        ENCODED_SAML2_BEARER_GRANT = HttpUtils.urlEncode((String)"urn:ietf:params:oauth:grant-type:saml2-bearer", (String)"UTF-8");
    }
}

