/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.utils;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.MD5SequenceGenerator;
import org.apache.cxf.security.LoginSecurityContext;
import org.apache.cxf.security.SecurityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OAuthUtils {
    private OAuthUtils() {
    }

    public static UserSubject createSubject(SecurityContext securityContext) {
        List<String> roleNames = Collections.emptyList();
        if (securityContext instanceof LoginSecurityContext) {
            roleNames = new ArrayList();
            Set roles = ((LoginSecurityContext)securityContext).getUserRoles();
            for (Principal p : roles) {
                roleNames.add(p.getName());
            }
        }
        return new UserSubject(securityContext.getUserPrincipal().getName(), roleNames);
    }

    public static String convertPermissionsToScope(List<OAuthPermission> perms) {
        StringBuilder sb = new StringBuilder();
        for (OAuthPermission perm : perms) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(perm.getPermission());
        }
        return sb.toString();
    }

    public static List<String> convertPermissionsToScopeList(List<OAuthPermission> perms) {
        LinkedList<String> list = new LinkedList<String>();
        for (OAuthPermission perm : perms) {
            list.add(perm.getPermission());
        }
        return list;
    }

    public static boolean isGrantSupportedForClient(Client client, boolean isConfidential, String grantType) {
        List<String> allowedGrants = client.getAllowedGrantTypes();
        return isConfidential == client.isConfidential() && (allowedGrants.isEmpty() || allowedGrants.contains(grantType));
    }

    public static List<String> parseScope(String requestedScope) {
        LinkedList<String> list = new LinkedList<String>();
        if (requestedScope != null) {
            String[] scopeValues;
            for (String scope : scopeValues = requestedScope.split(" ")) {
                if (StringUtils.isEmpty((String)scope)) continue;
                list.add(scope);
            }
        }
        return list;
    }

    public static String generateRandomTokenKey() throws OAuthServiceException {
        try {
            byte[] bytes = UUID.randomUUID().toString().getBytes("UTF-8");
            return new MD5SequenceGenerator().generate(bytes);
        }
        catch (Exception ex) {
            throw new OAuthServiceException("server_error", (Throwable)ex);
        }
    }

    public static boolean isExpired(Long issuedAt, Long lifetime) {
        return lifetime != -1L && issuedAt + lifetime < System.currentTimeMillis() / 1000L;
    }

    public static boolean checkRequestURI(String servletPath, String uri) {
        boolean wildcard = uri.endsWith("*");
        String theURI = wildcard ? uri.substring(0, uri.length() - 1) : uri;
        try {
            URITemplate template = new URITemplate(theURI);
            MetadataMap map = new MetadataMap();
            if (template.match(servletPath, (MultivaluedMap)map)) {
                String finalGroup = (String)map.getFirst((Object)"FINAL_MATCH_GROUP");
                if (wildcard || StringUtils.isEmpty((String)finalGroup) || "/".equals(finalGroup)) {
                    return true;
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return false;
    }
}

