/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.filters;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.ext.form.Form;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.common.OAuthContext;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.services.AbstractAccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.utils.AuthorizationUtils;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.security.SecurityContext;

@Provider
public class OAuthRequestFilter
extends AbstractAccessTokenValidator
implements RequestHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(OAuthRequestFilter.class);
    private boolean useUserSubject;
    private boolean audienceIsEndpointAddress;
    private boolean checkFormData;

    public Response handleRequest(Message m, ClassResourceInfo resourceClass) {
        this.validateRequest(m);
        return null;
    }

    protected void validateRequest(Message m) {
        if (this.isCorsRequest(m)) {
            return;
        }
        String[] authParts = this.getAuthorizationParts(m);
        String authScheme = authParts[0];
        String authSchemeData = authParts[1];
        AccessTokenValidation accessTokenV = this.getAccessTokenValidation(authScheme, authSchemeData);
        List<OAuthPermission> permissions = accessTokenV.getTokenScopes();
        ArrayList<OAuthPermission> matchingPermissions = new ArrayList<OAuthPermission>();
        HttpServletRequest req = this.getMessageContext().getHttpServletRequest();
        for (OAuthPermission perm : permissions) {
            boolean uriOK = this.checkRequestURI(req, perm.getUris());
            boolean verbOK = this.checkHttpVerb(req, perm.getHttpVerbs());
            if (!uriOK || !verbOK) continue;
            matchingPermissions.add(perm);
        }
        if (permissions.size() > 0 && matchingPermissions.isEmpty()) {
            String message = "Client has no valid permissions";
            LOG.warning(message);
            throw new WebApplicationException(403);
        }
        SecurityContext sc = this.createSecurityContext(req, accessTokenV);
        m.put(SecurityContext.class, (Object)sc);
        OAuthContext oauthContext = new OAuthContext(accessTokenV.getTokenSubject(), accessTokenV.getClientSubject(), matchingPermissions, accessTokenV.getTokenGrantType());
        oauthContext.setClientId(accessTokenV.getClientId());
        oauthContext.setTokenKey(accessTokenV.getTokenKey());
        oauthContext.setTokenAudience(accessTokenV.getAudience());
        m.setContent(OAuthContext.class, (Object)oauthContext);
    }

    protected boolean checkHttpVerb(HttpServletRequest req, List<String> verbs) {
        if (!verbs.isEmpty() && !verbs.contains(req.getMethod())) {
            String message = "Invalid http verb";
            LOG.fine(message);
            return false;
        }
        return true;
    }

    protected boolean checkRequestURI(HttpServletRequest request, List<String> uris) {
        if (uris.isEmpty()) {
            return true;
        }
        String servletPath = request.getPathInfo();
        boolean foundValidScope = false;
        for (String uri : uris) {
            if (!OAuthUtils.checkRequestURI(servletPath, uri)) continue;
            foundValidScope = true;
            break;
        }
        if (!foundValidScope) {
            String message = "Invalid request URI: " + request.getRequestURL().toString();
            LOG.warning(message);
        }
        return foundValidScope;
    }

    public void setUseUserSubject(boolean useUserSubject) {
        this.useUserSubject = useUserSubject;
    }

    protected SecurityContext createSecurityContext(HttpServletRequest request, AccessTokenValidation accessTokenV) {
        UserSubject resourceOwnerSubject = accessTokenV.getTokenSubject();
        UserSubject clientSubject = accessTokenV.getClientSubject();
        final UserSubject theSubject = this.useUserSubject ? resourceOwnerSubject : clientSubject;
        return new SecurityContext(){

            public Principal getUserPrincipal() {
                return theSubject != null ? new SimplePrincipal(theSubject.getLogin()) : null;
            }

            public boolean isUserInRole(String role) {
                if (theSubject == null) {
                    return false;
                }
                return theSubject.getRoles().contains(role);
            }
        };
    }

    protected boolean isCorsRequest(Message m) {
        return MessageUtils.isTrue((Object)m.get((Object)"local_preflight"));
    }

    @Override
    protected boolean validateAudience(String audience) {
        if (audience == null) {
            return true;
        }
        boolean isValid = super.validateAudience(audience);
        if (isValid && this.audienceIsEndpointAddress) {
            String requestPath = (String)PhaseInterceptorChain.getCurrentMessage().get((Object)"org.apache.cxf.request.url");
            isValid = requestPath.startsWith(audience);
        }
        return isValid;
    }

    public void setAudienceIsEndpointAddress(boolean audienceIsEndpointAddress) {
        this.audienceIsEndpointAddress = audienceIsEndpointAddress;
    }

    public void setCheckFormData(boolean checkFormData) {
        this.checkFormData = checkFormData;
    }

    protected String[] getAuthorizationParts(Message m) {
        if (!this.checkFormData) {
            return AuthorizationUtils.getAuthorizationParts(this.getMessageContext(), this.supportedSchemes);
        }
        return new String[]{"Bearer", this.getTokenFromFormData(m)};
    }

    protected String getTokenFromFormData(Message message) {
        String method = (String)message.get((Object)"org.apache.cxf.request.method");
        String type = (String)message.get((Object)"Content-Type");
        if (type != null && "application/x-www-form-urlencoded".startsWith(type) && method != null && (method.equals("POST") || method.equals("PUT"))) {
            try {
                FormEncodingProvider provider = new FormEncodingProvider(true);
                Form form = FormUtils.readForm((FormEncodingProvider)provider, (Message)message);
                MultivaluedMap formData = form.getData();
                String token = (String)formData.getFirst((Object)"access_token");
                if (token != null) {
                    FormUtils.restoreForm((FormEncodingProvider)provider, (Form)form, (Message)message);
                    return token;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        AuthorizationUtils.throwAuthorizationFailure(this.supportedSchemes, this.realm);
        return null;
    }
}

