/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.provider.ClientIdProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.services.AbstractOAuthService;
import org.apache.cxf.rs.security.oauth2.utils.AuthorizationUtils;
import org.apache.cxf.security.transport.TLSSessionInfo;

public class AbstractTokenService
extends AbstractOAuthService {
    private boolean canSupportPublicClients;
    private boolean writeCustomErrors;
    private ClientIdProvider clientIdProvider;

    protected Client authenticateClientIfNeeded(MultivaluedMap<String, String> params) {
        Client client = null;
        SecurityContext sc = this.getMessageContext().getSecurityContext();
        if (params.containsKey((Object)"client_id")) {
            client = this.getAndValidateClientFromIdAndSecret((String)params.getFirst((Object)"client_id"), (String)params.getFirst((Object)"client_secret"));
        } else if (sc.getUserPrincipal() != null) {
            Principal p = sc.getUserPrincipal();
            if (p.getName() != null) {
                client = this.getClient(p.getName());
            } else {
                String clientId = (String)this.getMessageContext().get((Object)"client_id");
                if (StringUtils.isEmpty((String)clientId) && this.clientIdProvider != null) {
                    clientId = this.clientIdProvider.getClientId(this.getMessageContext());
                }
                if (!StringUtils.isEmpty((String)clientId)) {
                    client = this.getClient(clientId);
                }
            }
        }
        if (client == null) {
            TLSSessionInfo tlsSessionInfo = (TLSSessionInfo)this.getMessageContext().get((Object)TLSSessionInfo.class.getName());
            client = this.getClientFromTLSCertificates(sc, tlsSessionInfo);
            if (client == null) {
                client = this.getClientFromBasicAuthScheme();
            }
            if (client != null && tlsSessionInfo != null) {
                this.compareTlsCertificates(tlsSessionInfo, client.getApplicationCertificate());
            }
        }
        if (client == null) {
            this.reportInvalidClient();
        }
        return client;
    }

    protected Client getAndValidateClientFromIdAndSecret(String clientId, String clientSecret) {
        Client client = this.getClient(clientId);
        if (this.canSupportPublicClients && !client.isConfidential() && client.getClientSecret() == null && clientSecret == null) {
            return client;
        }
        if (clientSecret == null || client.getClientSecret() == null || !client.getClientId().equals(clientId) || !client.getClientSecret().equals(clientSecret)) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
        return client;
    }

    protected Client getClientFromBasicAuthScheme() {
        String[] parts = AuthorizationUtils.getAuthorizationParts(this.getMessageContext());
        if ("Basic".equalsIgnoreCase(parts[0])) {
            String[] authInfo = AuthorizationUtils.getBasicAuthParts(parts[1]);
            return this.getAndValidateClientFromIdAndSecret(authInfo[0], authInfo[1]);
        }
        return null;
    }

    protected Client getClientFromTLSCertificates(SecurityContext sc, TLSSessionInfo tlsSessionInfo) {
        String clientId;
        Client client = null;
        if (tlsSessionInfo != null && StringUtils.isEmpty((String)sc.getAuthenticationScheme()) && !StringUtils.isEmpty((String)(clientId = this.getClientIdFromTLSCertificates(sc, tlsSessionInfo)))) {
            client = this.getClient(clientId);
        }
        return client;
    }

    protected String getClientIdFromTLSCertificates(SecurityContext sc, TLSSessionInfo tlsInfo) {
        Certificate[] clientCerts = tlsInfo.getPeerCertificates();
        if (clientCerts != null && clientCerts.length > 0) {
            X500Principal x509Principal = ((X509Certificate)clientCerts[0]).getSubjectX500Principal();
            return x509Principal.getName();
        }
        return null;
    }

    protected void compareTlsCertificates(TLSSessionInfo tlsInfo, String base64EncodedCert) {
        if (tlsInfo != null && base64EncodedCert != null) {
            Certificate[] clientCerts = tlsInfo.getPeerCertificates();
            try {
                X509Certificate cert = (X509Certificate)clientCerts[0];
                byte[] encodedKey = cert.getEncoded();
                byte[] clientKey = Base64Utility.decode((String)base64EncodedCert);
                if (Arrays.equals(encodedKey, clientKey)) {
                    return;
                }
            }
            catch (Exception ex) {
                this.reportInvalidClient();
            }
        }
    }

    protected Response handleException(OAuthServiceException ex, String error) {
        OAuthError customError = ex.getError();
        if (this.writeCustomErrors && customError != null) {
            return this.createErrorResponseFromBean(customError);
        }
        return this.createErrorResponseFromBean(new OAuthError(error));
    }

    protected Response createErrorResponse(MultivaluedMap<String, String> params, String error) {
        return this.createErrorResponseFromBean(new OAuthError(error));
    }

    protected Response createErrorResponseFromBean(OAuthError errorBean) {
        return JAXRSUtils.toResponseBuilder((int)400).entity((Object)errorBean).build();
    }

    protected Client getClient(String clientId) {
        Client client;
        block4: {
            if (clientId == null) {
                this.reportInvalidRequestError("Client ID is null");
                return null;
            }
            client = null;
            try {
                client = this.getValidClient(clientId);
            }
            catch (OAuthServiceException ex) {
                if (ex.getError() == null) break block4;
                this.reportInvalidClient(ex.getError());
                return null;
            }
        }
        if (client == null) {
            this.reportInvalidClient();
        }
        return client;
    }

    protected void reportInvalidClient() {
        this.reportInvalidClient(new OAuthError("invalid_client"));
    }

    protected void reportInvalidClient(OAuthError error) {
        Response.ResponseBuilder rb = JAXRSUtils.toResponseBuilder((int)401);
        throw ExceptionUtils.toNotAuthorizedException(null, (Response)rb.type(MediaType.APPLICATION_JSON_TYPE).entity((Object)error).build());
    }

    public void setCanSupportPublicClients(boolean support) {
        this.canSupportPublicClients = support;
    }

    public boolean isCanSupportPublicClients() {
        return this.canSupportPublicClients;
    }

    public void setWriteCustomErrors(boolean writeCustomErrors) {
        this.writeCustomErrors = writeCustomErrors;
    }

    public void setClientIdProvider(ClientIdProvider clientIdProvider) {
        this.clientIdProvider = clientIdProvider;
    }
}

