/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;

public final class MessageDigestUtils {
    public static final String ALGO_SHA_1 = "SHA-1";
    public static final String ALGO_SHA_256 = "SHA-256";
    public static final String ALGO_MD5 = "MD5";

    private MessageDigestUtils() {
    }

    public static String generate(byte[] input) throws OAuthServiceException {
        return MessageDigestUtils.generate(input, ALGO_MD5);
    }

    public static String generate(byte[] input, String algo) throws OAuthServiceException {
        if (input == null) {
            throw new OAuthServiceException("You have to pass input to Token Generator");
        }
        try {
            byte[] messageDigest = MessageDigestUtils.createDigest(input, algo);
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                hexString.append(Integer.toHexString(0xFF & messageDigest[i]));
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new OAuthServiceException("server_error", (Throwable)e);
        }
    }

    public static byte[] createDigest(String input, String algo) {
        try {
            return MessageDigestUtils.createDigest(input.getBytes("UTF-8"), algo);
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuthServiceException("server_error", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OAuthServiceException("server_error", (Throwable)e);
        }
    }

    public static byte[] createDigest(byte[] input, String algo) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algo);
        md.reset();
        md.update(input);
        return md.digest();
    }
}

