/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.SecretKey;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.common.util.crypto.KeyProperties;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.AbstractOAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.ClientRegistrationProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;
import org.apache.cxf.rs.security.oauth2.utils.crypto.ModelEncryptionSupport;

public class DefaultEncryptingOAuthDataProvider
extends AbstractOAuthDataProvider
implements ClientRegistrationProvider {
    protected SecretKey key;
    private Set<String> tokens = Collections.synchronizedSet(new HashSet());
    private ConcurrentHashMap<String, String> refreshTokens = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> clientsMap = new ConcurrentHashMap();

    public DefaultEncryptingOAuthDataProvider(String algo, int keySize) {
        this(new KeyProperties(algo, keySize));
    }

    public DefaultEncryptingOAuthDataProvider(KeyProperties props) {
        this(CryptoUtils.getSecretKey((KeyProperties)props));
    }

    public DefaultEncryptingOAuthDataProvider(SecretKey key) {
        this.key = key;
    }

    @Override
    public Client getClient(String clientId) throws OAuthServiceException {
        return ModelEncryptionSupport.decryptClient(this.clientsMap.get(clientId), this.key);
    }

    @Override
    public void setClient(Client client) {
        this.clientsMap.put(client.getClientId(), ModelEncryptionSupport.encryptClient(client, this.key));
    }

    @Override
    public Client removeClient(String clientId) {
        Client client = this.getClient(clientId);
        this.clientsMap.remove(clientId);
        this.removeClientTokens(client);
        return client;
    }

    @Override
    public List<Client> getClients() {
        ArrayList<Client> clients = new ArrayList<Client>(this.clientsMap.size());
        for (String clientKey : this.clientsMap.keySet()) {
            clients.add(this.getClient(clientKey));
        }
        return clients;
    }

    @Override
    protected List<ServerAccessToken> getAccessTokens(Client c) {
        ArrayList<ServerAccessToken> list = new ArrayList<ServerAccessToken>(this.tokens.size());
        for (String tokenKey : this.tokens) {
            ServerAccessToken token = this.getAccessToken(tokenKey);
            if (!token.getClient().getClientId().equals(c.getClientId())) continue;
            list.add(token);
        }
        return list;
    }

    @Override
    protected List<RefreshToken> getRefreshTokens(Client c) {
        ArrayList<RefreshToken> list = new ArrayList<RefreshToken>(this.refreshTokens.size());
        for (String tokenKey : this.tokens) {
            RefreshToken token = this.getRefreshToken(tokenKey);
            if (!token.getClient().getClientId().equals(c.getClientId())) continue;
            list.add(token);
        }
        return list;
    }

    @Override
    public ServerAccessToken getAccessToken(String accessToken) throws OAuthServiceException {
        return ModelEncryptionSupport.decryptAccessToken((OAuthDataProvider)this, accessToken, this.key);
    }

    @Override
    protected void saveAccessToken(ServerAccessToken serverToken) {
        this.encryptAccessToken(serverToken);
    }

    @Override
    protected ServerAccessToken revokeAccessToken(String accessTokenKey) {
        ServerAccessToken at = this.getAccessToken(accessTokenKey);
        this.tokens.remove(accessTokenKey);
        return at;
    }

    @Override
    protected void saveRefreshToken(ServerAccessToken at, RefreshToken refreshToken) {
        String encryptedRefreshToken = ModelEncryptionSupport.encryptRefreshToken(refreshToken, this.key);
        at.setRefreshToken(encryptedRefreshToken);
    }

    @Override
    protected RefreshToken revokeRefreshToken(String refreshTokenKey) {
        RefreshToken rt = null;
        if (this.refreshTokens.containsKey(refreshTokenKey)) {
            rt = this.getRefreshToken(refreshTokenKey);
            this.refreshTokens.remove(refreshTokenKey);
        }
        return rt;
    }

    private void encryptAccessToken(ServerAccessToken token) {
        String encryptedToken = ModelEncryptionSupport.encryptAccessToken(token, this.key);
        this.tokens.add(encryptedToken);
        this.refreshTokens.put(token.getRefreshToken(), encryptedToken);
        token.setTokenKey(encryptedToken);
    }

    @Override
    protected RefreshToken getRefreshToken(String refreshTokenKey) {
        try {
            return ModelEncryptionSupport.decryptRefreshToken((OAuthDataProvider)this, refreshTokenKey, this.key);
        }
        catch (SecurityException ex) {
            throw new OAuthServiceException("access_denied", (Throwable)ex);
        }
    }
}

