/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.provider.json.JsonMapObjectReaderWriter;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.AuthorizationCodeRequestFilter;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public class JwtRequestCodeFilter
implements AuthorizationCodeRequestFilter {
    private static final String REQUEST_PARAM = "request";
    private JweDecryptionProvider jweDecryptor;
    private JwsSignatureVerifier jwsVerifier;
    private boolean verifyWithClientCertificates;
    private boolean verifyWithClientSecret;
    private boolean decryptWithClientSecret;
    private String issuer;
    private JsonMapObjectReaderWriter jsonHandler = new JsonMapObjectReaderWriter();

    @Override
    public MultivaluedMap<String, String> process(MultivaluedMap<String, String> params, UserSubject endUser, Client client) {
        String requestToken = (String)params.getFirst((Object)REQUEST_PARAM);
        if (requestToken != null) {
            String iss;
            JwsSignatureVerifier theSigVerifier;
            JwsJwtCompactConsumer consumer;
            JweDecryptionProvider theJweDecryptor = this.getInitializedDecryptionProvider(client);
            if (theJweDecryptor != null) {
                requestToken = theJweDecryptor.decrypt(requestToken).getContentText();
            }
            if (!(consumer = new JwsJwtCompactConsumer(requestToken)).verifySignatureWith(theSigVerifier = this.getInitializedSigVerifier(client))) {
                throw new SecurityException("Invalid Signature");
            }
            JwtClaims claims = consumer.getJwtClaims();
            String string = iss = this.issuer != null ? this.issuer : client.getClientId();
            if (!iss.equals(claims.getIssuer()) || claims.getClaim("client_id") != null && claims.getStringProperty("client_id").equals(client.getClientId())) {
                throw new SecurityException();
            }
            MetadataMap newParams = new MetadataMap();
            Map claimsMap = claims.asMap();
            for (Map.Entry entry : claimsMap.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Map) {
                    Map map = CastUtils.cast((Map)((Map)value));
                    value = this.jsonHandler.toJson(map);
                } else if (value instanceof List) {
                    List list = CastUtils.cast((List)((List)value));
                    value = this.jsonHandler.toJson(list);
                }
                newParams.putSingle((Object)key, (Object)value.toString());
            }
            return newParams;
        }
        return params;
    }

    public void setJweDecryptor(JweDecryptionProvider jweDecryptor) {
        this.jweDecryptor = jweDecryptor;
    }

    public void setJweVerifier(JwsSignatureVerifier theJwsVerifier) {
        this.jwsVerifier = theJwsVerifier;
    }

    protected JweDecryptionProvider getInitializedDecryptionProvider(Client c) {
        if (this.jweDecryptor != null) {
            return this.jweDecryptor;
        }
        if (this.decryptWithClientSecret) {
            SecretKey key = CryptoUtils.decodeSecretKey((String)c.getClientSecret());
            return JweUtils.getDirectKeyJweDecryption((SecretKey)key, (String)"A128GCM");
        }
        return JweUtils.loadDecryptionProvider((boolean)false);
    }

    protected JwsSignatureVerifier getInitializedSigVerifier(Client c) {
        if (this.jwsVerifier != null) {
            return this.jwsVerifier;
        }
        if (this.verifyWithClientSecret) {
            byte[] hmac = CryptoUtils.decodeSequence((String)c.getClientSecret());
            return JwsUtils.getHmacSignatureVerifier((byte[])hmac, (String)"HS256");
        }
        if (this.verifyWithClientCertificates) {
            X509Certificate cert = (X509Certificate)CryptoUtils.decodeCertificate((String)c.getApplicationCertificates().get(0));
            return JwsUtils.getPublicKeySignatureVerifier((X509Certificate)cert, (String)"RS256");
        }
        return JwsUtils.loadSignatureVerifier((boolean)true);
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setVerifyWithClientCertificates(boolean verifyWithClientCertificates) {
        if (this.verifyWithClientSecret) {
            throw new SecurityException();
        }
        this.verifyWithClientCertificates = verifyWithClientCertificates;
    }

    public void setVerifyWithClientSecret(boolean verifyWithClientSecret) {
        if (this.decryptWithClientSecret || this.verifyWithClientCertificates) {
            throw new SecurityException();
        }
        this.verifyWithClientSecret = verifyWithClientSecret;
    }

    public void setDecryptWithClientSecret(boolean decryptWithClientSecret) {
        if (this.verifyWithClientSecret) {
            throw new SecurityException();
        }
        this.decryptWithClientSecret = decryptWithClientSecret;
    }
}

