/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.jwt;

import java.util.List;
import java.util.Set;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.grants.AbstractGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;

public abstract class AbstractJwtHandler
extends AbstractGrantHandler {
    private Set<String> supportedIssuers;
    private JwsSignatureVerifier jwsVerifier;
    private int ttl;
    private int clockOffset;

    protected AbstractJwtHandler(List<String> grants) {
        super(grants);
    }

    protected void validateSignature(JwsHeaders headers, String unsignedText, byte[] signature) {
        JwsSignatureVerifier theSigVerifier = this.getInitializedSigVerifier();
        if (!theSigVerifier.verify(headers, unsignedText, signature)) {
            throw new OAuthServiceException("invalid_grant");
        }
    }

    protected void validateClaims(Client client, JwtClaims claims) {
        this.validateIssuer(claims.getIssuer());
        this.validateSubject(client, claims.getSubject());
        this.validateAudience(client, claims.getAudience());
        boolean expiredRequired = claims.getIssuedAt() == null;
        JwtUtils.validateJwtExpiry((JwtClaims)claims, (int)this.clockOffset, (boolean)expiredRequired);
        JwtUtils.validateJwtNotBefore((JwtClaims)claims, (int)this.clockOffset, (boolean)false);
        boolean issuedAtRequired = claims.getExpiryTime() == null;
        JwtUtils.validateJwtIssuedAt((JwtClaims)claims, (int)this.ttl, (int)this.clockOffset, (boolean)issuedAtRequired);
    }

    protected void validateIssuer(String issuer) {
        if (issuer == null || !this.supportedIssuers.contains(issuer)) {
            throw new OAuthServiceException("invalid_grant");
        }
    }

    protected void validateSubject(Client client, String subject) {
    }

    protected void validateAudience(Client client, String audience) {
    }

    public void setSupportedIssuers(Set<String> supportedIssuers) {
        this.supportedIssuers = supportedIssuers;
    }

    public void setJwsVerifier(JwsSignatureVerifier jwsVerifier) {
        this.jwsVerifier = jwsVerifier;
    }

    protected JwsSignatureVerifier getInitializedSigVerifier() {
        if (this.jwsVerifier != null) {
            return this.jwsVerifier;
        }
        return JwsUtils.loadSignatureVerifier((boolean)true);
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public int getClockOffset() {
        return this.clockOffset;
    }

    public void setClockOffset(int clockOffset) {
        this.clockOffset = clockOffset;
    }
}

