/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.io.Serializable;
import net.sf.ehcache.Ehcache;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.rs.security.oauth2.grants.code.AbstractCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeRegistration;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.DefaultEHCacheOAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;

public class DefaultEHCacheCodeDataProvider
extends DefaultEHCacheOAuthDataProvider
implements AuthorizationCodeDataProvider {
    public static final String CODE_GRANT_CACHE_KEY = "cxf.oauth2.codegrant.cache";
    private long codeLifetime = 600L;
    private Ehcache codeGrantCache;

    protected DefaultEHCacheCodeDataProvider() {
        this("cxf-oauth2-ehcache.xml", BusFactory.getThreadDefaultBus((boolean)true));
    }

    protected DefaultEHCacheCodeDataProvider(String configFileURL, Bus bus) {
        this(configFileURL, bus, "cxf.oauth2.client.cache", CODE_GRANT_CACHE_KEY, "cxf.oauth2.accesstoken.cache", "cxf.oauth2.refreshtoken.cache");
    }

    protected DefaultEHCacheCodeDataProvider(String configFileURL, Bus bus, String clientCacheKey, String codeCacheKey, String accessTokenKey, String refreshTokenKey) {
        super(configFileURL, bus, clientCacheKey, accessTokenKey, refreshTokenKey);
        this.codeGrantCache = DefaultEHCacheCodeDataProvider.createCache(this.cacheManager, codeCacheKey);
    }

    @Override
    public ServerAuthorizationCodeGrant createCodeGrant(AuthorizationCodeRegistration reg) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = AbstractCodeDataProvider.initCodeGrant(reg, this.codeLifetime);
        this.saveCodeGrant(grant);
        return grant;
    }

    @Override
    public ServerAuthorizationCodeGrant removeCodeGrant(String code) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = DefaultEHCacheCodeDataProvider.getCacheValue(this.codeGrantCache, code, ServerAuthorizationCodeGrant.class);
        if (grant != null) {
            this.codeGrantCache.remove((Serializable)((Object)code));
        }
        return grant;
    }

    protected void saveCodeGrant(ServerAuthorizationCodeGrant grant) {
        DefaultEHCacheCodeDataProvider.putCacheValue(this.codeGrantCache, grant.getCode(), grant, grant.getExpiresIn());
    }

    public void setCodeLifetime(long codeLifetime) {
        this.codeLifetime = codeLifetime;
    }
}

