/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.io.Serializable;
import java.util.List;
import net.sf.ehcache.Ehcache;
import org.apache.cxf.Bus;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeRegistration;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.DefaultEHCacheOAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class DefaultEHCacheCodeDataProvider
extends DefaultEHCacheOAuthDataProvider
implements AuthorizationCodeDataProvider {
    public static final String CODE_GRANT_CACHE_KEY = "cxf.oauth2.client.cache";
    private long grantLifetime;
    private Ehcache codeGrantCache;

    protected DefaultEHCacheCodeDataProvider() {
        this("cxf-oauth2-ehcache.xml", null);
    }

    protected DefaultEHCacheCodeDataProvider(String configFileURL, Bus bus) {
        this(configFileURL, bus, CODE_GRANT_CACHE_KEY, CODE_GRANT_CACHE_KEY, "cxf.oauth2.accesstoken.cache", "cxf.oauth2.refreshtoken.cache");
    }

    protected DefaultEHCacheCodeDataProvider(String configFileURL, Bus bus, String clientCacheKey, String codeCacheKey, String accessTokenKey, String refreshTokenKey) {
        super(configFileURL, bus, clientCacheKey, accessTokenKey, refreshTokenKey);
        this.codeGrantCache = DefaultEHCacheCodeDataProvider.createCache(this.cacheManager, codeCacheKey);
    }

    @Override
    public ServerAuthorizationCodeGrant createCodeGrant(AuthorizationCodeRegistration reg) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = this.doCreateCodeGrant(reg);
        this.saveAuthorizationGrant(grant);
        return grant;
    }

    @Override
    public ServerAuthorizationCodeGrant removeCodeGrant(String code) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = DefaultEHCacheCodeDataProvider.getCacheValue(this.codeGrantCache, code, ServerAuthorizationCodeGrant.class);
        if (grant != null) {
            this.codeGrantCache.remove((Serializable)((Object)code));
        }
        return grant;
    }

    protected ServerAuthorizationCodeGrant doCreateCodeGrant(AuthorizationCodeRegistration reg) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = new ServerAuthorizationCodeGrant(reg.getClient(), this.getCode(reg), this.getGrantLifetime(), this.getIssuedAt());
        grant.setApprovedScopes(this.getApprovedScopes(reg));
        grant.setAudience(reg.getAudience());
        grant.setClientCodeChallenge(reg.getClientCodeChallenge());
        grant.setSubject(reg.getSubject());
        grant.setRedirectUri(reg.getRedirectUri());
        return grant;
    }

    protected List<String> getApprovedScopes(AuthorizationCodeRegistration reg) {
        return reg.getApprovedScope();
    }

    protected String getCode(AuthorizationCodeRegistration reg) {
        return OAuthUtils.generateRandomTokenKey();
    }

    public long getGrantLifetime() {
        return this.grantLifetime;
    }

    public void setGrantLifetime(long lifetime) {
        this.grantLifetime = lifetime;
    }

    protected long getIssuedAt() {
        return OAuthUtils.getIssuedAt();
    }

    protected void saveAuthorizationGrant(ServerAuthorizationCodeGrant grant) {
        DefaultEHCacheCodeDataProvider.putCacheValue(this.codeGrantCache, grant.getCode(), grant, grant.getExpiresIn());
    }
}

