/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.oauth2.client.ClientCodeStateManager;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContext;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContextImpl;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContextManager;
import org.apache.cxf.rs.security.oauth2.client.Consumer;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

@PreMatching
@Priority(value=1001)
public class ClientCodeRequestFilter
implements ContainerRequestFilter {
    @Context
    private MessageContext mc;
    private String scopes;
    private String completeUri;
    private String startUri;
    private String authorizationServiceUri;
    private Consumer consumer;
    private ClientCodeStateManager clientStateManager;
    private ClientTokenContextManager clientTokenContextManager;
    private WebClient accessTokenServiceClient;
    private boolean decodeRequestParameters;
    private long expiryThreshold;
    private String redirectUri;

    public void filter(ContainerRequestContext rc) throws IOException {
        String referer;
        this.checkSecurityContextStart(rc.getSecurityContext());
        UriInfo ui = rc.getUriInfo();
        String absoluteRequestUri = ui.getAbsolutePath().toString();
        boolean sameUriRedirect = false;
        if (this.completeUri == null && (referer = rc.getHeaderString("Referer")) != null && referer.startsWith(this.authorizationServiceUri)) {
            this.completeUri = absoluteRequestUri;
            sameUriRedirect = true;
        }
        if (!sameUriRedirect && absoluteRequestUri.endsWith(this.startUri)) {
            ClientTokenContext request = this.getClientTokenContext(rc);
            if (request != null) {
                this.setClientCodeRequest(request);
                if (this.completeUri != null) {
                    rc.setRequestUri(URI.create(this.completeUri));
                }
                return;
            }
            Response codeResponse = this.createCodeResponse(rc, ui);
            rc.abortWith(codeResponse);
        } else if (absoluteRequestUri.endsWith(this.completeUri)) {
            this.processCodeResponse(rc, ui);
            this.checkSecurityContextEnd(rc.getSecurityContext());
        }
    }

    protected void checkSecurityContextStart(SecurityContext sc) {
        this.checkSecurityContextEnd(sc);
    }

    private void checkSecurityContextEnd(SecurityContext sc) {
        if (sc == null || sc.getUserPrincipal() == null) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
    }

    private Response createCodeResponse(ContainerRequestContext rc, UriInfo ui) {
        MultivaluedMap<String, String> redirectState = this.createRedirectState(rc, ui);
        String theState = redirectState != null ? (String)redirectState.getFirst((Object)"scope") : null;
        String redirectScope = redirectState != null ? (String)redirectState.getFirst((Object)"scope") : null;
        String theScope = redirectScope != null ? redirectScope : this.scopes;
        URI uri = OAuthClientUtils.getAuthorizationURI(this.authorizationServiceUri, this.consumer.getKey(), this.getAbsoluteRedirectUri(ui).toString(), theState, theScope);
        return Response.seeOther((URI)uri).build();
    }

    private URI getAbsoluteRedirectUri(UriInfo ui) {
        if (this.redirectUri != null) {
            return URI.create(this.redirectUri);
        }
        if (this.completeUri != null) {
            return this.completeUri.startsWith("http") ? URI.create(this.completeUri) : ui.getBaseUriBuilder().path(this.completeUri).build(new Object[0]);
        }
        return ui.getAbsolutePath();
    }

    protected void processCodeResponse(ContainerRequestContext rc, UriInfo ui) {
        MultivaluedMap<String, String> params = this.toRequestState(rc, ui);
        String codeParam = (String)params.getFirst((Object)"code");
        ClientAccessToken at = null;
        if (codeParam != null) {
            AuthorizationCodeGrant grant = new AuthorizationCodeGrant(codeParam, this.getAbsoluteRedirectUri(ui));
            at = OAuthClientUtils.getAccessToken(this.accessTokenServiceClient, this.consumer, grant);
        }
        ClientTokenContext tokenContext = this.initializeClientTokenContext(rc, at, params);
        if (at != null && this.clientTokenContextManager != null) {
            this.clientTokenContextManager.setClientTokenContext(this.mc, tokenContext);
        }
        this.setClientCodeRequest(tokenContext);
    }

    protected ClientTokenContext initializeClientTokenContext(ContainerRequestContext rc, ClientAccessToken at, MultivaluedMap<String, String> params) {
        ClientTokenContext tokenContext = this.createTokenContext(rc, at);
        ((ClientTokenContextImpl)tokenContext).setToken(at);
        if (this.clientStateManager != null) {
            MultivaluedMap<String, String> state = this.clientStateManager.fromRedirectState(this.mc, params);
            ((ClientTokenContextImpl)tokenContext).setState(state);
        }
        return tokenContext;
    }

    protected ClientTokenContext createTokenContext(ContainerRequestContext rc, ClientAccessToken at) {
        return new ClientTokenContextImpl();
    }

    private void setClientCodeRequest(ClientTokenContext request) {
        JAXRSUtils.getCurrentMessage().setContent(ClientTokenContext.class, (Object)request);
    }

    private MultivaluedMap<String, String> createRedirectState(ContainerRequestContext rc, UriInfo ui) {
        if (this.clientStateManager == null) {
            return null;
        }
        return this.clientStateManager.toRedirectState(this.mc, this.toRequestState(rc, ui));
    }

    private MultivaluedMap<String, String> toRequestState(ContainerRequestContext rc, UriInfo ui) {
        MetadataMap requestState = new MetadataMap();
        requestState.putAll((Map)ui.getQueryParameters(this.decodeRequestParameters));
        if (MediaType.APPLICATION_FORM_URLENCODED_TYPE.isCompatible(rc.getMediaType())) {
            String body = FormUtils.readBody((InputStream)rc.getEntityStream(), (String)"UTF-8");
            FormUtils.populateMapFromString((MultivaluedMap)requestState, (Message)JAXRSUtils.getCurrentMessage(), (String)body, (String)"UTF-8", (boolean)this.decodeRequestParameters);
        }
        return requestState;
    }

    public void setScopeList(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(s);
        }
        this.setScopes(sb.toString());
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public void setStartUri(String relStartUri) {
        this.startUri = relStartUri;
    }

    public void setAuthorizationServiceUri(String authorizationServiceUri) {
        this.authorizationServiceUri = authorizationServiceUri;
    }

    public void setCompleteUri(String completeUri) {
        this.completeUri = completeUri;
    }

    public void setAccessTokenServiceClient(WebClient accessTokenServiceClient) {
        this.accessTokenServiceClient = accessTokenServiceClient;
    }

    public void setClientCodeStateManager(ClientCodeStateManager manager) {
        this.clientStateManager = manager;
    }

    public void setClientTokenContextManager(ClientTokenContextManager clientTokenContextManager) {
        this.clientTokenContextManager = clientTokenContextManager;
    }

    public void setConsumer(Consumer consumer) {
        this.consumer = consumer;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public void setDecodeRequestParameters(boolean decodeRequestParameters) {
        this.decodeRequestParameters = decodeRequestParameters;
    }

    protected ClientTokenContext getClientTokenContext(ContainerRequestContext rc) {
        ClientAccessToken newAt;
        ClientTokenContext ctx = null;
        if (this.clientTokenContextManager != null && (ctx = this.clientTokenContextManager.getClientTokenContext(this.mc)) != null && (newAt = this.refreshAccessTokenIfExpired(ctx.getToken())) != null) {
            this.clientTokenContextManager.removeClientTokenContext(this.mc, ctx);
            ClientTokenContext newCtx = this.initializeClientTokenContext(rc, newAt, ctx.getState());
            this.clientTokenContextManager.setClientTokenContext(this.mc, newCtx);
            ctx = newCtx;
        }
        return ctx;
    }

    private ClientAccessToken refreshAccessTokenIfExpired(ClientAccessToken at) {
        if (at.getRefreshToken() != null && (this.expiryThreshold > 0L && OAuthUtils.isExpired(at.getIssuedAt(), at.getExpiresIn() - this.expiryThreshold) || OAuthUtils.isExpired(at.getIssuedAt(), at.getExpiresIn()))) {
            return OAuthClientUtils.refreshAccessToken(this.accessTokenServiceClient, this.consumer, at);
        }
        return null;
    }

    public void setExpiryThreshold(long expiryThreshold) {
        this.expiryThreshold = expiryThreshold;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }
}

