/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.client;

import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.provider.json.JsonMapObjectReaderWriter;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jws.NoneJwsSignatureProvider;
import org.apache.cxf.rs.security.oauth2.client.ClientCodeStateManager;

public class JoseClientCodeStateManager
implements ClientCodeStateManager {
    private JwsSignatureProvider sigProvider;
    private JweEncryptionProvider encryptionProvider;
    private JweDecryptionProvider decryptionProvider;
    private JwsSignatureVerifier signatureVerifier;
    private JsonMapObjectReaderWriter jsonp = new JsonMapObjectReaderWriter();

    @Override
    public MultivaluedMap<String, String> toRedirectState(MessageContext mc, MultivaluedMap<String, String> requestState) {
        Map stateMap = CastUtils.cast(requestState);
        String json = this.jsonp.toJson(stateMap);
        JwsCompactProducer producer = new JwsCompactProducer(json);
        JwsSignatureProvider theSigProvider = this.getInitializedSigProvider();
        String stateParam = producer.signWith(theSigProvider);
        JweEncryptionProvider theEncryptionProvider = this.getInitializedEncryptionProvider();
        if (theEncryptionProvider != null) {
            stateParam = theEncryptionProvider.encrypt(StringUtils.toBytesUTF8((String)stateParam), null);
        }
        MetadataMap map = new MetadataMap();
        map.putSingle((Object)"state", (Object)stateParam);
        return map;
    }

    @Override
    public MultivaluedMap<String, String> fromRedirectState(MessageContext mc, MultivaluedMap<String, String> redirectState) {
        JwsSignatureVerifier theSigVerifier;
        JwsCompactConsumer jws;
        String stateParam = (String)redirectState.getFirst((Object)"state");
        JweDecryptionProvider jwe = this.getInitializedDecryptionProvider();
        if (jwe != null) {
            stateParam = jwe.decrypt(stateParam).getContentText();
        }
        if (!(jws = new JwsCompactConsumer(stateParam)).verifySignatureWith(theSigVerifier = this.getInitializedSigVerifier())) {
            throw new SecurityException();
        }
        String json = jws.getUnsignedEncodedSequence();
        Map map = CastUtils.cast((Map)this.jsonp.fromJson(json));
        return (MultivaluedMap)map;
    }

    public void setSignatureProvider(JwsSignatureProvider signatureProvider) {
        this.sigProvider = signatureProvider;
    }

    protected JwsSignatureProvider getInitializedSigProvider() {
        if (this.sigProvider != null) {
            return this.sigProvider;
        }
        JwsSignatureProvider theSigProvider = JwsUtils.loadSignatureProvider((boolean)false);
        if (theSigProvider == null) {
            theSigProvider = new NoneJwsSignatureProvider();
        }
        return theSigProvider;
    }

    public void setDecryptionProvider(JweDecryptionProvider decProvider) {
        this.decryptionProvider = decProvider;
    }

    protected JweDecryptionProvider getInitializedDecryptionProvider() {
        if (this.decryptionProvider != null) {
            return this.decryptionProvider;
        }
        return JweUtils.loadDecryptionProvider((boolean)false);
    }

    public void setSignatureVerifier(JwsSignatureVerifier signatureVerifier) {
        this.signatureVerifier = signatureVerifier;
    }

    protected JwsSignatureVerifier getInitializedSigVerifier() {
        if (this.signatureVerifier != null) {
            return this.signatureVerifier;
        }
        return JwsUtils.loadSignatureVerifier((boolean)false);
    }

    public void setEncryptionProvider(JweEncryptionProvider encProvider) {
        this.encryptionProvider = encProvider;
    }

    protected JweEncryptionProvider getInitializedEncryptionProvider() {
        if (this.encryptionProvider != null) {
            return this.encryptionProvider;
        }
        return JweUtils.loadEncryptionProvider((boolean)false);
    }
}

