/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.utils;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.oauth2.common.AuthenticationMethod;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rt.security.crypto.CryptoUtils;
import org.apache.cxf.security.LoginSecurityContext;
import org.apache.cxf.security.SecurityContext;

public final class OAuthUtils {
    private OAuthUtils() {
    }

    public static String setDefaultSessionToken(MessageContext mc) {
        return OAuthUtils.setDefaultSessionToken(mc, 0);
    }

    public static String setDefaultSessionToken(MessageContext mc, int maxInactiveInterval) {
        return OAuthUtils.setDefaultSessionToken(mc, OAuthUtils.generateRandomTokenKey());
    }

    public static String setDefaultSessionToken(MessageContext mc, String sessionToken) {
        return OAuthUtils.setDefaultSessionToken(mc, sessionToken, 0);
    }

    public static String setDefaultSessionToken(MessageContext mc, String sessionToken, int maxInactiveInterval) {
        HttpSession session = mc.getHttpServletRequest().getSession();
        if (maxInactiveInterval > 0) {
            session.setMaxInactiveInterval(maxInactiveInterval);
        }
        session.setAttribute("session_authenticity_token", (Object)sessionToken);
        return sessionToken;
    }

    public static String getDefaultSessionToken(MessageContext mc) {
        HttpSession session = mc.getHttpServletRequest().getSession();
        String sessionToken = (String)session.getAttribute("session_authenticity_token");
        if (sessionToken != null) {
            session.removeAttribute("session_authenticity_token");
        }
        return sessionToken;
    }

    public static UserSubject createSubject(SecurityContext securityContext) {
        List<String> roleNames = Collections.emptyList();
        if (securityContext instanceof LoginSecurityContext) {
            roleNames = new ArrayList();
            Set roles = ((LoginSecurityContext)securityContext).getUserRoles();
            for (Principal p : roles) {
                roleNames.add(p.getName());
            }
        }
        UserSubject subject = new UserSubject(securityContext.getUserPrincipal().getName(), roleNames);
        Message m = JAXRSUtils.getCurrentMessage();
        if (m != null && m.get(AuthenticationMethod.class) != null) {
            subject.setAthenticationMethod((AuthenticationMethod)((Object)m.get(AuthenticationMethod.class)));
        }
        return subject;
    }

    public static String convertPermissionsToScope(List<OAuthPermission> perms) {
        StringBuilder sb = new StringBuilder();
        for (OAuthPermission perm : perms) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(perm.getPermission());
        }
        return sb.toString();
    }

    public static List<String> convertPermissionsToScopeList(List<OAuthPermission> perms) {
        LinkedList<String> list = new LinkedList<String>();
        for (OAuthPermission perm : perms) {
            list.add(perm.getPermission());
        }
        return list;
    }

    public static boolean isGrantSupportedForClient(Client client, boolean canSupportPublicClients, String grantType) {
        if (!client.isConfidential() && !canSupportPublicClients) {
            return false;
        }
        List<String> allowedGrants = client.getAllowedGrantTypes();
        return allowedGrants.isEmpty() || allowedGrants.contains(grantType);
    }

    public static List<String> parseScope(String requestedScope) {
        LinkedList<String> list = new LinkedList<String>();
        if (requestedScope != null) {
            String[] scopeValues;
            for (String scope : scopeValues = requestedScope.split(" ")) {
                if (StringUtils.isEmpty((String)scope)) continue;
                list.add(scope);
            }
        }
        return list;
    }

    public static String generateRandomTokenKey() throws OAuthServiceException {
        return OAuthUtils.generateRandomTokenKey(16);
    }

    public static String generateRandomTokenKey(int byteSize) {
        if (byteSize < 16) {
            throw new OAuthServiceException();
        }
        return StringUtils.toHexString((byte[])CryptoUtils.generateSecureRandomBytes((int)byteSize));
    }

    public static long getIssuedAt() {
        return System.currentTimeMillis() / 1000L;
    }

    public static boolean isExpired(Long issuedAt, Long lifetime) {
        return lifetime != -1L && issuedAt + lifetime < System.currentTimeMillis() / 1000L;
    }

    public static boolean validateAudience(String audience, List<String> audiences) {
        return audience == null || !audiences.isEmpty() && audiences.contains(audience);
    }

    public static boolean checkRequestURI(String servletPath, String uri) {
        boolean wildcard = uri.endsWith("*");
        String theURI = wildcard ? uri.substring(0, uri.length() - 1) : uri;
        try {
            URITemplate template = new URITemplate(theURI);
            MetadataMap map = new MetadataMap();
            if (template.match(servletPath, (MultivaluedMap)map)) {
                String finalGroup = (String)map.getFirst((Object)"FINAL_MATCH_GROUP");
                if (wildcard || StringUtils.isEmpty((String)finalGroup) || "/".equals(finalGroup)) {
                    return true;
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return false;
    }

    public static List<String> getRequestedScopes(Client client, String scopeParameter, boolean partialMatchScopeValidation) {
        List<String> requestScopes = OAuthUtils.parseScope(scopeParameter);
        List<String> registeredScopes = client.getRegisteredScopes();
        if (requestScopes.isEmpty()) {
            requestScopes.addAll(registeredScopes);
            return requestScopes;
        }
        if (!OAuthUtils.validateScopes(requestScopes, registeredScopes, partialMatchScopeValidation)) {
            throw new OAuthServiceException("Unexpected scope");
        }
        return requestScopes;
    }

    public static boolean validateScopes(List<String> requestScopes, List<String> registeredScopes, boolean partialMatchScopeValidation) {
        if (!registeredScopes.isEmpty()) {
            if (!partialMatchScopeValidation) {
                return registeredScopes.containsAll(requestScopes);
            }
            for (String requestScope : requestScopes) {
                boolean match = false;
                for (String registeredScope : registeredScopes) {
                    if (!requestScope.startsWith(registeredScope)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
        }
        return true;
    }

    public static ClientAccessToken toClientAccessToken(ServerAccessToken serverToken, boolean supportOptionalParams) {
        ClientAccessToken clientToken = new ClientAccessToken(serverToken.getTokenType(), serverToken.getTokenKey());
        clientToken.setRefreshToken(serverToken.getRefreshToken());
        if (supportOptionalParams) {
            clientToken.setExpiresIn(serverToken.getExpiresIn());
            List<OAuthPermission> perms = serverToken.getScopes();
            if (!perms.isEmpty()) {
                clientToken.setApprovedScope(OAuthUtils.convertPermissionsToScope(perms));
            }
            clientToken.setParameters(serverToken.getParameters());
        }
        return clientToken;
    }
}

