/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants;

import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenRegistration;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public abstract class AbstractGrantHandler
implements AccessTokenGrantHandler {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractGrantHandler.class);
    private List<String> supportedGrants;
    private OAuthDataProvider dataProvider;
    private boolean partialMatchScopeValidation;
    private boolean canSupportPublicClients;

    protected AbstractGrantHandler(String grant) {
        this.supportedGrants = Collections.singletonList(grant);
    }

    protected AbstractGrantHandler(List<String> grants) {
        if (grants.isEmpty()) {
            throw new IllegalArgumentException("The list of grant types can not be empty");
        }
        this.supportedGrants = grants;
    }

    public void setDataProvider(OAuthDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public OAuthDataProvider getDataProvider() {
        return this.dataProvider;
    }

    @Override
    public List<String> getSupportedGrantTypes() {
        return Collections.unmodifiableList(this.supportedGrants);
    }

    @Deprecated
    protected void checkIfGrantSupported(Client client) {
        this.checkIfGrantSupported(client, this.getSingleGrantType());
    }

    private void checkIfGrantSupported(Client client, String requestedGrant) {
        if (!OAuthUtils.isGrantSupportedForClient(client, this.canSupportPublicClients, requestedGrant)) {
            throw new OAuthServiceException("unauthorized_client");
        }
    }

    protected String getSingleGrantType() {
        if (this.supportedGrants.size() > 1) {
            String errorMessage = "Request grant type must be specified";
            LOG.warning(errorMessage);
            throw new WebApplicationException(500);
        }
        return this.supportedGrants.get(0);
    }

    protected ServerAccessToken doCreateAccessToken(Client client, UserSubject subject, MultivaluedMap<String, String> params) {
        return this.doCreateAccessToken(client, subject, OAuthUtils.parseScope((String)params.getFirst((Object)"scope")), this.getAudiences(client, (String)params.getFirst((Object)"audience")));
    }

    protected ServerAccessToken doCreateAccessToken(Client client, UserSubject subject, List<String> requestedScopes) {
        return this.doCreateAccessToken(client, subject, this.getSingleGrantType(), requestedScopes);
    }

    protected ServerAccessToken doCreateAccessToken(Client client, UserSubject subject, List<String> requestedScopes, List<String> audiences) {
        return this.doCreateAccessToken(client, subject, this.getSingleGrantType(), requestedScopes, audiences);
    }

    protected ServerAccessToken doCreateAccessToken(Client client, UserSubject subject, String requestedGrant, List<String> requestedScopes) {
        return this.doCreateAccessToken(client, subject, requestedGrant, requestedScopes, null);
    }

    protected ServerAccessToken doCreateAccessToken(Client client, UserSubject subject, String requestedGrant, List<String> requestedScopes, List<String> audiences) {
        ServerAccessToken token = this.getPreAuthorizedToken(client, subject, requestedGrant, requestedScopes, audiences);
        if (token != null) {
            return token;
        }
        AccessTokenRegistration reg = new AccessTokenRegistration();
        reg.setClient(client);
        reg.setGrantType(requestedGrant);
        reg.setSubject(subject);
        reg.setRequestedScope(requestedScopes);
        reg.setApprovedScope(this.getApprovedScopes(client, subject, requestedScopes));
        reg.setAudiences(audiences);
        return this.dataProvider.createAccessToken(reg);
    }

    protected List<String> getApprovedScopes(Client client, UserSubject subject, List<String> requestedScopes) {
        return Collections.emptyList();
    }

    protected ServerAccessToken getPreAuthorizedToken(Client client, UserSubject subject, String requestedGrant, List<String> requestedScopes, List<String> audiences) {
        if (!OAuthUtils.validateScopes(requestedScopes, client.getRegisteredScopes(), this.partialMatchScopeValidation)) {
            throw new OAuthServiceException(new OAuthError("invalid_scope"));
        }
        if (!OAuthUtils.validateAudiences(audiences, client.getRegisteredAudiences())) {
            throw new OAuthServiceException(new OAuthError("invalid_grant"));
        }
        return this.dataProvider.getPreauthorizedToken(client, requestedScopes, subject, requestedGrant);
    }

    public boolean isPartialMatchScopeValidation() {
        return this.partialMatchScopeValidation;
    }

    public void setPartialMatchScopeValidation(boolean partialMatchScopeValidation) {
        this.partialMatchScopeValidation = partialMatchScopeValidation;
    }

    public void setCanSupportPublicClients(boolean support) {
        this.canSupportPublicClients = support;
    }

    public boolean isCanSupportPublicClients() {
        return this.canSupportPublicClients;
    }

    protected List<String> getAudiences(Client client, String clientAudience) {
        if (client.getRegisteredAudiences().isEmpty() && clientAudience == null) {
            return Collections.emptyList();
        }
        if (clientAudience != null) {
            List<String> audiences = Collections.singletonList(clientAudience);
            if (!OAuthUtils.validateAudiences(audiences, client.getRegisteredAudiences())) {
                throw new OAuthServiceException("invalid_grant");
            }
            return audiences;
        }
        return client.getRegisteredAudiences();
    }
}

