/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.util.logging.Logger;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public abstract class AbstractOAuthService {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractOAuthService.class);
    private MessageContext mc;
    private OAuthDataProvider dataProvider;
    private boolean blockUnsecureRequests;
    private boolean writeOptionalParameters = true;

    public void setWriteOptionalParameters(boolean write) {
        this.writeOptionalParameters = write;
    }

    public boolean isWriteOptionalParameters() {
        return this.writeOptionalParameters;
    }

    @Context
    public void setMessageContext(MessageContext context) {
        this.mc = context;
        this.injectContextIntoOAuthProviders();
    }

    protected void injectContextIntoOAuthProviders() {
        OAuthUtils.injectContextIntoOAuthProvider(this.mc, this.dataProvider);
    }

    public MessageContext getMessageContext() {
        return this.mc;
    }

    public void setDataProvider(OAuthDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public OAuthDataProvider getDataProvider() {
        return this.dataProvider;
    }

    protected MultivaluedMap<String, String> getQueryParameters() {
        return this.getMessageContext().getUriInfo().getQueryParameters();
    }

    protected Client getValidClient(String clientId, MultivaluedMap<String, String> params) throws OAuthServiceException {
        if (clientId != null) {
            this.mc.put((Object)"client_secret", params.getFirst((Object)"client_secret"));
            this.mc.put((Object)"grant_type", params.getFirst((Object)"grant_type"));
            this.mc.put((Object)"token_request_params", params);
            return this.dataProvider.getClient(clientId);
        }
        LOG.fine("No valid client found as the given clientId is null");
        return null;
    }

    protected void checkTransportSecurity() {
        if (!this.mc.getSecurityContext().isSecure()) {
            LOG.warning("Unsecure HTTP, HTTPS is recommended");
            if (this.blockUnsecureRequests) {
                throw ExceptionUtils.toBadRequestException(null, null);
            }
        }
    }

    protected void reportInvalidRequestError(String errorDescription) {
        this.reportInvalidRequestError(errorDescription, MediaType.APPLICATION_JSON_TYPE);
    }

    protected void reportInvalidRequestError(String errorDescription, MediaType mt) {
        OAuthError error = new OAuthError("invalid_request", errorDescription);
        this.reportInvalidRequestError(error, mt);
    }

    protected void reportInvalidRequestError(OAuthError entity) {
        this.reportInvalidRequestError(entity, MediaType.APPLICATION_JSON_TYPE);
    }

    protected void reportInvalidRequestError(OAuthError entity, MediaType mt) {
        Response.ResponseBuilder rb = JAXRSUtils.toResponseBuilder((int)400);
        if (mt != null) {
            rb.type(mt);
        }
        throw ExceptionUtils.toBadRequestException(null, (Response)rb.entity((Object)entity).build());
    }

    public void setBlockUnsecureRequests(boolean blockUnsecureRequests) {
        this.blockUnsecureRequests = blockUnsecureRequests;
    }
}

