/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.util.Collections;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.code.JPACodeDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.JPAOAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;

public class JPACMTCodeDataProvider
extends JPACodeDataProvider {
    private static final int DEFAULT_PESSIMISTIC_LOCK_TIMEOUT = 10000;
    private int pessimisticLockTimeout = 10000;
    private boolean useJpaLockForExistingRefreshToken = true;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    protected EntityTransaction beginIfNeeded(EntityManager em) {
        return null;
    }

    @Override
    protected void commitIfNeeded(EntityManager em) {
    }

    @Override
    protected void closeIfNeeded(EntityManager em) {
    }

    @Override
    protected RefreshToken updateExistingRefreshToken(RefreshToken rt, ServerAccessToken at) {
        if (this.useJpaLockForExistingRefreshToken) {
            this.lockRefreshTokenForUpdate(rt);
            return super.updateRefreshToken(rt, at);
        }
        return super.updateExistingRefreshToken(rt, at);
    }

    protected void lockRefreshTokenForUpdate(final RefreshToken refreshToken) {
        try {
            this.execute(new JPAOAuthDataProvider.EntityManagerOperation<Void>(){

                @Override
                public Void execute(EntityManager em) {
                    Map<Object, Object> options = null;
                    options = JPACMTCodeDataProvider.this.pessimisticLockTimeout > 0 ? Collections.singletonMap("javax.persistence.lock.timeout", JPACMTCodeDataProvider.this.pessimisticLockTimeout) : Collections.emptyMap();
                    em.refresh((Object)refreshToken, LockModeType.PESSIMISTIC_WRITE, options);
                    return null;
                }
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setPessimisticLockTimeout(int pessimisticLockTimeout) {
        this.pessimisticLockTimeout = pessimisticLockTimeout;
    }

    public void setUseJpaLockForExistingRefreshToken(boolean useJpaLockForExistingRefreshToken) {
        this.useJpaLockForExistingRefreshToken = useJpaLockForExistingRefreshToken;
    }
}

