/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.client;

import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.rs.security.oauth2.client.ClientCodeStateManager;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class MemoryClientCodeStateManager
implements ClientCodeStateManager {
    private ConcurrentHashMap<String, MultivaluedMap<String, String>> map = new ConcurrentHashMap();

    @Override
    public MultivaluedMap<String, String> toRedirectState(MessageContext mc, MultivaluedMap<String, String> requestState) {
        String stateParam = OAuthUtils.generateRandomTokenKey();
        this.map.put(stateParam, requestState);
        OAuthUtils.setSessionToken(mc, stateParam, "state", 0);
        MetadataMap redirectMap = new MetadataMap();
        redirectMap.putSingle((Object)"state", (Object)stateParam);
        return redirectMap;
    }

    @Override
    public MultivaluedMap<String, String> fromRedirectState(MessageContext mc, MultivaluedMap<String, String> redirectState) {
        String stateParam = (String)redirectState.getFirst((Object)"state");
        String sessionToken = OAuthUtils.getSessionToken(mc, "state");
        if (!sessionToken.equals(stateParam)) {
            throw new OAuthServiceException("Invalid session token");
        }
        return this.map.remove(stateParam);
    }
}

