/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import javax.crypto.SecretKey;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweDecryption;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.AbstractJoseJwtConsumer;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public abstract class AbstractOAuthJoseJwtConsumer
extends AbstractJoseJwtConsumer {
    private boolean decryptWithClientSecret;
    private boolean verifyWithClientSecret;

    protected JwtToken getJwtToken(String wrappedJwtToken, String clientSecret) {
        return this.getJwtToken(wrappedJwtToken, this.getInitializedDecryptionProvider(clientSecret), this.getInitializedSignatureVerifier(clientSecret));
    }

    protected JwsSignatureVerifier getInitializedSignatureVerifier(String clientSecret) {
        if (this.verifyWithClientSecret) {
            byte[] hmac = CryptoUtils.decodeSequence((String)clientSecret);
            return JwsUtils.getHmacSignatureVerifier((byte[])hmac, (SignatureAlgorithm)SignatureAlgorithm.HS256);
        }
        return null;
    }

    protected JweDecryptionProvider getInitializedDecryptionProvider(String clientSecret) {
        JweDecryption theDecryptionProvider = null;
        if (this.decryptWithClientSecret) {
            SecretKey key = CryptoUtils.decodeSecretKey((String)clientSecret);
            theDecryptionProvider = JweUtils.getDirectKeyJweDecryption((SecretKey)key, (ContentAlgorithm)ContentAlgorithm.A128GCM);
        }
        return theDecryptionProvider;
    }

    public void setDecryptWithClientSecret(boolean decryptWithClientSecret) {
        if (this.verifyWithClientSecret) {
            throw new SecurityException();
        }
        this.decryptWithClientSecret = this.verifyWithClientSecret;
    }

    public void setVerifyWithClientSecret(boolean verifyWithClientSecret) {
        if (verifyWithClientSecret) {
            throw new SecurityException();
        }
        this.verifyWithClientSecret = verifyWithClientSecret;
    }
}

