/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.net.URI;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthAuthorizationData;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.OAuthRedirectionState;
import org.apache.cxf.rs.security.oauth2.common.OOBAuthorizationResponse;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeRegistration;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.AuthorizationCodeRequestFilter;
import org.apache.cxf.rs.security.oauth2.provider.AuthorizationCodeResponseFilter;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.provider.OOBResponseDeliverer;
import org.apache.cxf.rs.security.oauth2.services.RedirectionBasedGrantService;

@Path(value="/authorize")
public class AuthorizationCodeGrantService
extends RedirectionBasedGrantService {
    private static final Integer RECOMMENDED_CODE_EXPIRY_TIME_MINS = 10;
    private boolean canSupportPublicClients;
    private boolean canSupportEmptyRedirectForPrivateClients;
    private OOBResponseDeliverer oobDeliverer;
    private AuthorizationCodeRequestFilter codeRequestFilter;
    private AuthorizationCodeResponseFilter codeResponseFilter;

    public AuthorizationCodeGrantService() {
        super("code", "authorization_code");
    }

    @Override
    protected OAuthAuthorizationData createAuthorizationData(Client client, MultivaluedMap<String, String> params, String redirectUri, UserSubject subject, List<OAuthPermission> perms, boolean authorizationCanBeSkipped) {
        OAuthAuthorizationData data = super.createAuthorizationData(client, params, redirectUri, subject, perms, authorizationCanBeSkipped);
        AuthorizationCodeGrantService.setCodeQualifier(data, params);
        return data;
    }

    @Override
    protected OAuthRedirectionState recreateRedirectionStateFromSession(UserSubject subject, MultivaluedMap<String, String> params, String sessionToken) {
        OAuthRedirectionState state = super.recreateRedirectionStateFromSession(subject, params, sessionToken);
        AuthorizationCodeGrantService.setCodeQualifier(state, params);
        return state;
    }

    private static void setCodeQualifier(OAuthRedirectionState data, MultivaluedMap<String, String> params) {
        data.setClientCodeChallenge((String)params.getFirst((Object)"code_challenge"));
    }

    @Override
    protected Response startAuthorization(MultivaluedMap<String, String> params, UserSubject userSubject, Client client) {
        if (this.codeRequestFilter != null) {
            params = this.codeRequestFilter.process(params, userSubject, client);
        }
        return super.startAuthorization(params, userSubject, client);
    }

    @Override
    protected Response createGrant(OAuthRedirectionState state, Client client, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preauthorizedToken) {
        AuthorizationCodeRegistration codeReg = new AuthorizationCodeRegistration();
        codeReg.setClient(client);
        codeReg.setRedirectUri(state.getRedirectUri());
        codeReg.setRequestedScope(requestedScope);
        if (approvedScope != null && approvedScope.isEmpty()) {
            codeReg.setApprovedScope(requestedScope);
        } else {
            codeReg.setApprovedScope(approvedScope);
        }
        codeReg.setSubject(userSubject);
        codeReg.setAudience(state.getAudience());
        codeReg.setClientCodeChallenge(state.getClientCodeChallenge());
        ServerAuthorizationCodeGrant grant = null;
        try {
            grant = ((AuthorizationCodeDataProvider)this.getDataProvider()).createCodeGrant(codeReg);
        }
        catch (OAuthServiceException ex) {
            return this.createErrorResponse(state.getState(), state.getRedirectUri(), "access_denied");
        }
        if (grant.getExpiresIn() / 60L > (long)RECOMMENDED_CODE_EXPIRY_TIME_MINS.intValue()) {
            LOG.warning("Code expiry time exceeds 10 minutes");
        }
        String grantCode = this.processCodeGrant(client, grant.getCode(), grant.getSubject());
        if (state.getRedirectUri() == null) {
            OOBAuthorizationResponse oobResponse = new OOBAuthorizationResponse();
            oobResponse.setClientId(client.getClientId());
            oobResponse.setAuthorizationCode(grant.getCode());
            oobResponse.setUserId(userSubject.getLogin());
            oobResponse.setExpiresIn(grant.getExpiresIn());
            return this.deliverOOBResponse(oobResponse);
        }
        UriBuilder ub = this.getRedirectUriBuilder(state.getState(), state.getRedirectUri());
        ub.queryParam("code", new Object[]{grantCode});
        return Response.seeOther((URI)ub.build(new Object[0])).build();
    }

    protected String processCodeGrant(Client client, String code, UserSubject endUser) {
        if (this.codeResponseFilter != null) {
            return this.codeResponseFilter.process(client, code, endUser);
        }
        return code;
    }

    protected Response deliverOOBResponse(OOBAuthorizationResponse response) {
        if (this.oobDeliverer != null) {
            return this.oobDeliverer.deliver(response);
        }
        return Response.ok((Object)response).type("text/html").build();
    }

    @Override
    protected Response createErrorResponse(String state, String redirectUri, String error) {
        if (redirectUri == null) {
            return Response.status((int)401).entity((Object)error).build();
        }
        UriBuilder ub = this.getRedirectUriBuilder(state, redirectUri);
        ub.queryParam("error", new Object[]{error});
        return Response.seeOther((URI)ub.build(new Object[0])).build();
    }

    protected UriBuilder getRedirectUriBuilder(String state, String redirectUri) {
        UriBuilder ub = UriBuilder.fromUri((String)redirectUri);
        if (state != null) {
            ub.queryParam("state", new Object[]{state});
        }
        return ub;
    }

    @Override
    protected boolean canSupportPublicClient(Client c) {
        return this.canSupportPublicClients && !c.isConfidential() && c.getClientSecret() == null;
    }

    @Override
    protected boolean canRedirectUriBeEmpty(Client c) {
        return (c.isConfidential() && this.canSupportEmptyRedirectForPrivateClients || this.canSupportPublicClient(c)) && c.getRedirectUris().isEmpty();
    }

    public void setCanSupportPublicClients(boolean support) {
        this.canSupportPublicClients = support;
    }

    public void setCodeResponseFilter(AuthorizationCodeResponseFilter filter) {
        this.codeResponseFilter = filter;
    }

    public void setCodeRequestFilter(AuthorizationCodeRequestFilter codeRequestFilter) {
        this.codeRequestFilter = codeRequestFilter;
    }

    public void setCanSupportEmptyRedirectForPrivateClients(boolean canSupportEmptyRedirectForPrivateClients) {
        this.canSupportEmptyRedirectForPrivateClients = canSupportEmptyRedirectForPrivateClients;
    }
}

