/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthAuthorizationData;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.OAuthRedirectionState;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.provider.ResourceOwnerNameProvider;
import org.apache.cxf.rs.security.oauth2.provider.SessionAuthenticityTokenProvider;
import org.apache.cxf.rs.security.oauth2.provider.SubjectCreator;
import org.apache.cxf.rs.security.oauth2.services.AbstractOAuthService;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.security.SecurityContext;

public abstract class RedirectionBasedGrantService
extends AbstractOAuthService {
    private String supportedResponseType;
    private String supportedGrantType;
    private boolean partialMatchScopeValidation;
    private boolean useRegisteredRedirectUriIfPossible = true;
    private SessionAuthenticityTokenProvider sessionAuthenticityTokenProvider;
    private SubjectCreator subjectCreator;
    private ResourceOwnerNameProvider resourceOwnerNameProvider;
    private int maxDefaultSessionInterval;
    private boolean matchRedirectUriWithApplicationUri;

    protected RedirectionBasedGrantService(String supportedResponseType, String supportedGrantType) {
        this.supportedResponseType = supportedResponseType;
        this.supportedGrantType = supportedGrantType;
    }

    @GET
    @Produces(value={"application/xhtml+xml", "text/html", "application/xml", "application/json"})
    public Response authorize() {
        MultivaluedMap<String, String> params = this.getQueryParameters();
        return this.startAuthorization(params);
    }

    @GET
    @Path(value="/decision")
    public Response authorizeDecision() {
        MultivaluedMap<String, String> params = this.getQueryParameters();
        return this.completeAuthorization(params);
    }

    @POST
    @Path(value="/decision")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response authorizeDecisionForm(MultivaluedMap<String, String> params) {
        return this.completeAuthorization(params);
    }

    protected Response startAuthorization(MultivaluedMap<String, String> params) {
        SecurityContext sc = this.getAndValidateSecurityContext(params);
        UserSubject userSubject = this.createUserSubject(sc);
        Client client = this.getClient(params);
        return this.startAuthorization(params, userSubject, client);
    }

    protected Response startAuthorization(MultivaluedMap<String, String> params, UserSubject userSubject, Client client) {
        String redirectUri = this.validateRedirectUri(client, (String)params.getFirst((Object)"redirect_uri"));
        if (!OAuthUtils.isGrantSupportedForClient(client, this.canSupportPublicClient(client), this.supportedGrantType)) {
            return this.createErrorResponse(params, redirectUri, "unauthorized_client");
        }
        String responseType = (String)params.getFirst((Object)"response_type");
        if (responseType == null || !responseType.equals(this.supportedResponseType)) {
            return this.createErrorResponse(params, redirectUri, "unsupported_response_type");
        }
        String providedScope = (String)params.getFirst((Object)"scope");
        List<String> requestedScope = null;
        try {
            requestedScope = OAuthUtils.getRequestedScopes(client, providedScope, this.partialMatchScopeValidation);
        }
        catch (OAuthServiceException ex) {
            return this.createErrorResponse(params, redirectUri, "invalid_scope");
        }
        List<OAuthPermission> requestedPermissions = null;
        try {
            requestedPermissions = this.getDataProvider().convertScopeToPermissions(client, requestedScope);
        }
        catch (OAuthServiceException ex) {
            return this.createErrorResponse(params, redirectUri, "invalid_scope");
        }
        if (!OAuthUtils.validateAudience((String)params.getFirst((Object)"audience"), client.getRegisteredAudiences())) {
            throw new OAuthServiceException(new OAuthError("invalid_request"));
        }
        ServerAccessToken preAuthorizedToken = this.getDataProvider().getPreauthorizedToken(client, requestedScope, userSubject, this.supportedGrantType);
        boolean authorizationCanBeSkipped = preAuthorizedToken != null || this.canAuthorizationBeSkipped(client, requestedScope, requestedPermissions);
        OAuthAuthorizationData data = this.createAuthorizationData(client, params, redirectUri, userSubject, requestedPermissions, authorizationCanBeSkipped);
        if (authorizationCanBeSkipped) {
            List<OAuthPermission> approvedScopes = preAuthorizedToken != null ? preAuthorizedToken.getScopes() : requestedPermissions;
            return this.createGrant(data, client, requestedScope, OAuthUtils.convertPermissionsToScopeList(approvedScopes), userSubject, preAuthorizedToken);
        }
        return Response.ok((Object)data).build();
    }

    protected boolean canAuthorizationBeSkipped(Client client, List<String> requestedScope, List<OAuthPermission> permissions) {
        return false;
    }

    protected OAuthAuthorizationData createAuthorizationData(Client client, MultivaluedMap<String, String> params, String redirectUri, UserSubject subject, List<OAuthPermission> perms, boolean authorizationCanBeSkipped) {
        OAuthAuthorizationData secData = new OAuthAuthorizationData();
        secData.setState((String)params.getFirst((Object)"state"));
        secData.setRedirectUri(redirectUri);
        secData.setAudience((String)params.getFirst((Object)"audience"));
        secData.setClientId(client.getClientId());
        secData.setProposedScope((String)params.getFirst((Object)"scope"));
        if (!authorizationCanBeSkipped) {
            secData.setPermissions(perms);
            secData.setApplicationName(client.getApplicationName());
            secData.setApplicationWebUri(client.getApplicationWebUri());
            secData.setApplicationDescription(client.getApplicationDescription());
            secData.setApplicationLogoUri(client.getApplicationLogoUri());
            secData.setApplicationCertificates(client.getApplicationCertificates());
            Map<String, String> extraProperties = client.getProperties();
            secData.setExtraApplicationProperties(extraProperties);
            String replyTo = this.getMessageContext().getUriInfo().getAbsolutePathBuilder().path("decision").build(new Object[0]).toString();
            secData.setReplyTo(replyTo);
            this.personalizeData(secData, subject);
            this.addAuthenticityTokenToSession(secData, params, subject);
        }
        return secData;
    }

    protected OAuthRedirectionState recreateRedirectionStateFromSession(UserSubject subject, MultivaluedMap<String, String> params, String sessionToken) {
        OAuthRedirectionState state = null;
        if (this.sessionAuthenticityTokenProvider != null) {
            state = this.sessionAuthenticityTokenProvider.getSessionState(super.getMessageContext(), sessionToken, subject);
        }
        if (state == null) {
            state = new OAuthRedirectionState();
            state.setClientId((String)params.getFirst((Object)"client_id"));
            state.setRedirectUri((String)params.getFirst((Object)"redirect_uri"));
            state.setAudience((String)params.getFirst((Object)"audience"));
            state.setProposedScope((String)params.getFirst((Object)"scope"));
            state.setState((String)params.getFirst((Object)"state"));
        }
        return state;
    }

    protected void personalizeData(OAuthAuthorizationData data, UserSubject userSubject) {
        if (this.resourceOwnerNameProvider != null) {
            data.setEndUserName(this.resourceOwnerNameProvider.getName(userSubject));
        }
    }

    protected Response completeAuthorization(MultivaluedMap<String, String> params) {
        String sessionToken;
        SecurityContext securityContext = this.getAndValidateSecurityContext(params);
        UserSubject userSubject = this.createUserSubject(securityContext);
        String sessionTokenParamName = (String)params.getFirst((Object)"session_authenticity_token_param_name");
        if (sessionTokenParamName == null) {
            sessionTokenParamName = "session_authenticity_token";
        }
        if (!this.compareRequestAndSessionTokens(sessionToken = (String)params.getFirst((Object)sessionTokenParamName), params, userSubject)) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        OAuthRedirectionState state = this.recreateRedirectionStateFromSession(userSubject, params, sessionToken);
        Client client = this.getClient(state.getClientId());
        String redirectUri = this.validateRedirectUri(client, state.getRedirectUri());
        String decision = (String)params.getFirst((Object)"oauthDecision");
        boolean allow = "allow".equals(decision);
        if (!allow) {
            return this.createErrorResponse(params, redirectUri, "access_denied");
        }
        List<String> requestedScope = OAuthUtils.parseScope(state.getProposedScope());
        LinkedList<String> approvedScope = new LinkedList<String>();
        for (String rScope : requestedScope) {
            String param = (String)params.getFirst((Object)(rScope + "_status"));
            if (param == null || !"allow".equals(param)) continue;
            approvedScope.add(rScope);
        }
        if (!requestedScope.containsAll(approvedScope) || !OAuthUtils.validateScopes(requestedScope, client.getRegisteredScopes(), this.partialMatchScopeValidation)) {
            return this.createErrorResponse(params, redirectUri, "invalid_scope");
        }
        return this.createGrant(state, client, requestedScope, approvedScope, userSubject, null);
    }

    public void setSessionAuthenticityTokenProvider(SessionAuthenticityTokenProvider sessionAuthenticityTokenProvider) {
        this.sessionAuthenticityTokenProvider = sessionAuthenticityTokenProvider;
    }

    public void setSubjectCreator(SubjectCreator creator) {
        this.subjectCreator = creator;
    }

    protected UserSubject createUserSubject(SecurityContext securityContext) {
        UserSubject subject = null;
        if (this.subjectCreator != null && (subject = this.subjectCreator.createUserSubject(this.getMessageContext())) != null) {
            return subject;
        }
        subject = (UserSubject)this.getMessageContext().getContent(UserSubject.class);
        if (subject != null) {
            return subject;
        }
        return OAuthUtils.createSubject(securityContext);
    }

    protected Response createErrorResponse(MultivaluedMap<String, String> params, String redirectUri, String error) {
        return this.createErrorResponse((String)params.getFirst((Object)"state"), redirectUri, error);
    }

    protected abstract Response createErrorResponse(String var1, String var2, String var3);

    protected abstract Response createGrant(OAuthRedirectionState var1, Client var2, List<String> var3, List<String> var4, UserSubject var5, ServerAccessToken var6);

    protected SecurityContext getAndValidateSecurityContext(MultivaluedMap<String, String> params) {
        SecurityContext securityContext = (SecurityContext)this.getMessageContext().get((Object)SecurityContext.class.getName());
        if (securityContext == null || securityContext.getUserPrincipal() == null) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
        this.checkTransportSecurity();
        return securityContext;
    }

    protected String validateRedirectUri(Client client, String redirectUri) {
        List<String> uris = client.getRedirectUris();
        if (redirectUri != null) {
            if (!uris.contains(redirectUri)) {
                redirectUri = null;
            }
        } else if (uris.size() == 1 && this.useRegisteredRedirectUriIfPossible) {
            redirectUri = uris.get(0);
        }
        if (redirectUri == null && uris.size() == 0 && !this.canRedirectUriBeEmpty(client)) {
            this.reportInvalidRequestError("Client Redirect Uri is invalid");
        }
        if (redirectUri != null && this.matchRedirectUriWithApplicationUri && client.getApplicationWebUri() != null && !redirectUri.startsWith(client.getApplicationWebUri())) {
            this.reportInvalidRequestError("Client Redirect Uri is invalid");
        }
        return redirectUri;
    }

    private void addAuthenticityTokenToSession(OAuthAuthorizationData secData, MultivaluedMap<String, String> params, UserSubject subject) {
        String sessionToken = this.sessionAuthenticityTokenProvider != null ? this.sessionAuthenticityTokenProvider.createSessionToken(this.getMessageContext(), params, subject, secData) : OAuthUtils.setSessionToken(this.getMessageContext(), this.maxDefaultSessionInterval);
        secData.setAuthenticityToken(sessionToken);
    }

    private boolean compareRequestAndSessionTokens(String requestToken, MultivaluedMap<String, String> params, UserSubject subject) {
        String sessionToken = this.sessionAuthenticityTokenProvider != null ? this.sessionAuthenticityTokenProvider.removeSessionToken(this.getMessageContext(), params, subject) : OAuthUtils.getSessionToken(this.getMessageContext());
        if (StringUtils.isEmpty((String)sessionToken)) {
            return false;
        }
        return requestToken.equals(sessionToken);
    }

    protected Client getClient(String clientId) {
        Client client;
        block3: {
            client = null;
            try {
                client = this.getValidClient(clientId);
            }
            catch (OAuthServiceException ex) {
                if (ex.getError() == null) break block3;
                this.reportInvalidRequestError(ex.getError(), null);
            }
        }
        if (client == null) {
            this.reportInvalidRequestError("Client ID is invalid", null);
        }
        return client;
    }

    protected Client getClient(MultivaluedMap<String, String> params) {
        return this.getClient((String)params.getFirst((Object)"client_id"));
    }

    protected String getSupportedGrantType() {
        return this.supportedGrantType;
    }

    public void setResourceOwnerNameProvider(ResourceOwnerNameProvider resourceOwnerNameProvider) {
        this.resourceOwnerNameProvider = resourceOwnerNameProvider;
    }

    public void setPartialMatchScopeValidation(boolean partialMatchScopeValidation) {
        this.partialMatchScopeValidation = partialMatchScopeValidation;
    }

    public void setUseRegisteredRedirectUriIfPossible(boolean use) {
        this.useRegisteredRedirectUriIfPossible = use;
    }

    protected abstract boolean canSupportPublicClient(Client var1);

    protected abstract boolean canRedirectUriBeEmpty(Client var1);

    public void setMaxDefaultSessionInterval(int maxDefaultSessionInterval) {
        this.maxDefaultSessionInterval = maxDefaultSessionInterval;
    }

    public void setMatchRedirectUriWithApplicationUri(boolean matchRedirectUriWithApplicationUri) {
        this.matchRedirectUriWithApplicationUri = matchRedirectUriWithApplicationUri;
    }
}

