/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.client;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContext;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContextManager;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class MemoryClientTokenContextManager
implements ClientTokenContextManager {
    private ConcurrentHashMap<String, ClientTokenContext> map = new ConcurrentHashMap();

    @Override
    public void setClientTokenContext(MessageContext mc, ClientTokenContext request) {
        String key = this.getKey(mc, false);
        if (key == null) {
            key = OAuthUtils.generateRandomTokenKey();
            OAuthUtils.setSessionToken(mc, key, "org.apache.cxf.websso.context", 0);
        }
        this.map.put(key, request);
    }

    @Override
    public ClientTokenContext getClientTokenContext(MessageContext mc) {
        return this.map.get(this.getKey(mc, false));
    }

    @Override
    public ClientTokenContext removeClientTokenContext(MessageContext mc) {
        return this.map.remove(this.getKey(mc, true));
    }

    private String getKey(MessageContext mc, boolean remove) {
        return OAuthUtils.getSessionToken(mc, "org.apache.cxf.websso.context", remove);
    }
}

