/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeRegistration;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.AbstractOAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;

public abstract class AbstractCodeDataProvider
extends AbstractOAuthDataProvider
implements AuthorizationCodeDataProvider {
    private long codeLifetime = 600L;

    protected AbstractCodeDataProvider() {
    }

    @Override
    public ServerAuthorizationCodeGrant createCodeGrant(AuthorizationCodeRegistration reg) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = this.doCreateCodeGrant(reg);
        this.saveCodeGrant(grant);
        return grant;
    }

    protected ServerAuthorizationCodeGrant doCreateCodeGrant(AuthorizationCodeRegistration reg) throws OAuthServiceException {
        return AbstractCodeDataProvider.initCodeGrant(reg, this.codeLifetime);
    }

    public void setCodeLifetime(long codeLifetime) {
        this.codeLifetime = codeLifetime;
    }

    protected void removeClientCodeGrants(Client c) {
        for (ServerAuthorizationCodeGrant grant : this.getCodeGrants(c, null)) {
            this.removeCodeGrant(grant.getCode());
        }
    }

    public static ServerAuthorizationCodeGrant initCodeGrant(AuthorizationCodeRegistration reg, long lifetime) {
        ServerAuthorizationCodeGrant grant = new ServerAuthorizationCodeGrant(reg.getClient(), lifetime);
        grant.setRedirectUri(reg.getRedirectUri());
        grant.setSubject(reg.getSubject());
        grant.setPreauthorizedTokenAvailable(reg.isPreauthorizedTokenAvailable());
        grant.setRequestedScopes(reg.getRequestedScope());
        grant.setApprovedScopes(reg.getApprovedScope());
        grant.setAudience(reg.getAudience());
        grant.setClientCodeChallenge(reg.getClientCodeChallenge());
        grant.setNonce(reg.getNonce());
        grant.getExtraProperties().putAll(reg.getExtraProperties());
        return grant;
    }

    protected abstract void saveCodeGrant(ServerAuthorizationCodeGrant var1);
}

