/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.common.AccessToken;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenRegistration;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.ClientRegistrationProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.bearer.BearerAccessToken;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public abstract class AbstractOAuthDataProvider
implements OAuthDataProvider,
ClientRegistrationProvider {
    private long accessTokenLifetime = 3600L;
    private long refreshTokenLifetime;
    private boolean recycleRefreshTokens = true;
    private Map<String, OAuthPermission> permissionMap = new HashMap<String, OAuthPermission>();
    private MessageContext messageContext;
    private List<String> defaultScopes;
    private List<String> requiredScopes;
    private List<String> invisibleToClientScopes;
    private boolean supportPreauthorizedTokens;

    protected AbstractOAuthDataProvider() {
    }

    @Override
    public ServerAccessToken createAccessToken(AccessTokenRegistration reg) throws OAuthServiceException {
        ServerAccessToken at = this.doCreateAccessToken(reg);
        this.saveAccessToken(at);
        if (this.isRefreshTokenSupported(reg.getApprovedScope())) {
            this.createNewRefreshToken(at);
        }
        return at;
    }

    protected ServerAccessToken doCreateAccessToken(AccessTokenRegistration atReg) {
        ServerAccessToken at = this.createNewAccessToken(atReg.getClient());
        at.setAudiences(atReg.getAudiences());
        at.setGrantType(atReg.getGrantType());
        List<String> theScopes = atReg.getApprovedScope();
        List<OAuthPermission> thePermissions = this.convertScopeToPermissions(atReg.getClient(), theScopes);
        at.setScopes(thePermissions);
        at.setSubject(atReg.getSubject());
        at.setClientCodeVerifier(atReg.getClientCodeVerifier());
        at.setNonce(atReg.getNonce());
        at.setResponseType(atReg.getResponseType());
        at.setGrantCode(atReg.getGrantCode());
        at.getExtraProperties().putAll(atReg.getExtraProperties());
        return at;
    }

    @Override
    public void removeAccessToken(ServerAccessToken token) throws OAuthServiceException {
        this.revokeAccessToken(token.getTokenKey());
    }

    @Override
    public ServerAccessToken refreshAccessToken(Client client, String refreshTokenKey, List<String> restrictedScopes) throws OAuthServiceException {
        RefreshToken currentRefreshToken;
        RefreshToken refreshToken = currentRefreshToken = this.recycleRefreshTokens ? this.revokeRefreshToken(refreshTokenKey) : this.getRefreshToken(refreshTokenKey);
        if (currentRefreshToken == null) {
            throw new OAuthServiceException("access_denied");
        }
        if (OAuthUtils.isExpired(currentRefreshToken.getIssuedAt(), currentRefreshToken.getExpiresIn())) {
            if (!this.recycleRefreshTokens) {
                this.revokeRefreshToken(refreshTokenKey);
            }
            throw new OAuthServiceException("access_denied");
        }
        if (this.recycleRefreshTokens) {
            this.revokeAccessTokens(currentRefreshToken);
        }
        ServerAccessToken at = this.doRefreshAccessToken(client, currentRefreshToken, restrictedScopes);
        this.saveAccessToken(at);
        if (this.recycleRefreshTokens) {
            this.createNewRefreshToken(at);
        } else {
            this.updateRefreshToken(currentRefreshToken, at);
        }
        return at;
    }

    @Override
    public void revokeToken(Client client, String tokenKey, String tokenTypeHint) throws OAuthServiceException {
        ServerAccessToken accessToken = null;
        if (!"refresh_token".equals(tokenTypeHint)) {
            accessToken = this.revokeAccessToken(tokenKey);
        }
        if (accessToken != null) {
            this.handleLinkedRefreshToken(accessToken);
        } else if (!"access_token".equals(tokenTypeHint)) {
            RefreshToken currentRefreshToken = this.revokeRefreshToken(tokenKey);
            this.revokeAccessTokens(currentRefreshToken);
        }
    }

    protected void handleLinkedRefreshToken(ServerAccessToken accessToken) {
        if (accessToken != null && accessToken.getRefreshToken() != null) {
            RefreshToken rt = this.getRefreshToken(accessToken.getRefreshToken());
            if (rt == null) {
                return;
            }
            this.unlinkRefreshAccessToken(rt, accessToken.getTokenKey());
            if (rt.getAccessTokens().isEmpty()) {
                this.revokeRefreshToken(rt.getTokenKey());
            } else {
                this.saveRefreshToken(null, rt);
            }
        }
    }

    protected void revokeAccessTokens(RefreshToken currentRefreshToken) {
        if (currentRefreshToken != null) {
            for (String accessTokenKey : currentRefreshToken.getAccessTokens()) {
                this.revokeAccessToken(accessTokenKey);
            }
        }
    }

    protected void unlinkRefreshAccessToken(RefreshToken rt, String tokenKey) {
        List<String> accessTokenKeys = rt.getAccessTokens();
        for (int i = 0; i < accessTokenKeys.size(); ++i) {
            if (!accessTokenKeys.get(i).equals(tokenKey)) continue;
            accessTokenKeys.remove(i);
            break;
        }
    }

    @Override
    public List<OAuthPermission> convertScopeToPermissions(Client client, List<String> requestedScopes) {
        if (this.requiredScopes != null && !requestedScopes.containsAll(this.requiredScopes)) {
            throw new OAuthServiceException("Required scopes are missing");
        }
        if (requestedScopes.isEmpty()) {
            return Collections.emptyList();
        }
        if (!this.permissionMap.isEmpty()) {
            ArrayList<OAuthPermission> list = new ArrayList<OAuthPermission>();
            for (String scope : requestedScopes) {
                OAuthPermission permission = this.permissionMap.get(scope);
                if (permission == null) {
                    throw new OAuthServiceException("Unexpected scope: " + scope);
                }
                list.add(permission);
            }
            return list;
        }
        throw new OAuthServiceException("Requested scopes can not be mapped");
    }

    @Override
    public ServerAccessToken getPreauthorizedToken(Client client, List<String> requestedScopes, UserSubject sub, String grantType) throws OAuthServiceException {
        if (!this.isSupportPreauthorizedTokens()) {
            return null;
        }
        AccessToken token = null;
        for (ServerAccessToken at : this.getAccessTokens(client, sub)) {
            if (!at.getClient().getClientId().equals(client.getClientId()) || !at.getGrantType().equals(grantType) || sub != null && !at.getSubject().getLogin().equals(sub.getLogin())) continue;
            token = at;
            break;
        }
        if (token != null && OAuthUtils.isExpired(token.getIssuedAt(), token.getExpiresIn())) {
            this.revokeToken(client, token.getTokenKey(), "access_token");
            token = null;
        }
        return token;
    }

    protected boolean isRefreshTokenSupported(List<String> theScopes) {
        return theScopes.contains("refreshToken");
    }

    protected ServerAccessToken createNewAccessToken(Client client) {
        return new BearerAccessToken(client, this.accessTokenLifetime);
    }

    protected RefreshToken updateRefreshToken(RefreshToken rt, ServerAccessToken at) {
        this.linkRefreshAccessTokens(rt, at);
        this.saveRefreshToken(at, rt);
        return rt;
    }

    protected RefreshToken createNewRefreshToken(ServerAccessToken at) {
        RefreshToken rt = this.doCreateNewRefreshToken(at);
        this.saveRefreshToken(at, rt);
        return rt;
    }

    protected RefreshToken doCreateNewRefreshToken(ServerAccessToken at) {
        RefreshToken rt = new RefreshToken(at.getClient(), this.refreshTokenLifetime);
        rt.setAudiences(at.getAudiences());
        rt.setGrantType(at.getGrantType());
        rt.setScopes(at.getScopes());
        rt.setSubject(at.getSubject());
        rt.setClientCodeVerifier(at.getClientCodeVerifier());
        this.linkRefreshAccessTokens(rt, at);
        return rt;
    }

    private void linkRefreshAccessTokens(RefreshToken rt, ServerAccessToken at) {
        rt.getAccessTokens().add(at.getTokenKey());
        at.setRefreshToken(rt.getTokenKey());
    }

    protected ServerAccessToken doRefreshAccessToken(Client client, RefreshToken oldRefreshToken, List<String> restrictedScopes) {
        ServerAccessToken at = this.createNewAccessToken(client);
        at.setAudiences(oldRefreshToken.getAudiences());
        at.setGrantType(oldRefreshToken.getGrantType());
        at.setSubject(oldRefreshToken.getSubject());
        if (restrictedScopes.isEmpty()) {
            at.setScopes(oldRefreshToken.getScopes());
        } else {
            List<OAuthPermission> theNewScopes = this.convertScopeToPermissions(client, restrictedScopes);
            if (oldRefreshToken.getScopes().containsAll(theNewScopes)) {
                at.setScopes(theNewScopes);
            } else {
                throw new OAuthServiceException("Invalid scopes");
            }
        }
        return at;
    }

    public void setAccessTokenLifetime(long accessTokenLifetime) {
        this.accessTokenLifetime = accessTokenLifetime;
    }

    public void setRefreshTokenLifetime(long refreshTokenLifetime) {
        this.refreshTokenLifetime = refreshTokenLifetime;
    }

    public void setRecycleRefreshTokens(boolean recycleRefreshTokens) {
        this.recycleRefreshTokens = recycleRefreshTokens;
    }

    public void init() {
        for (OAuthPermission perm : this.permissionMap.values()) {
            if (this.defaultScopes != null && this.defaultScopes.contains(perm.getPermission())) {
                perm.setDefault(true);
            }
            if (this.invisibleToClientScopes == null || !this.invisibleToClientScopes.contains(perm.getPermission())) continue;
            perm.setInvisibleToClient(true);
        }
    }

    public void close() {
    }

    public Map<String, OAuthPermission> getPermissionMap() {
        return this.permissionMap;
    }

    public void setPermissionMap(Map<String, OAuthPermission> permissionMap) {
        this.permissionMap = permissionMap;
    }

    public void setSupportedScopes(Map<String, String> scopes) {
        for (Map.Entry<String, String> entry : scopes.entrySet()) {
            OAuthPermission permission = new OAuthPermission(entry.getKey(), entry.getValue());
            this.permissionMap.put(entry.getKey(), permission);
        }
    }

    public MessageContext getMessageContext() {
        return this.messageContext;
    }

    public void setMessageContext(MessageContext messageContext) {
        this.messageContext = messageContext;
    }

    protected void removeClientTokens(Client c) {
        for (RefreshToken rt : this.getRefreshTokens(c, null)) {
            this.revokeRefreshToken(rt.getTokenKey());
        }
        for (ServerAccessToken at : this.getAccessTokens(c, null)) {
            this.revokeAccessToken(at.getTokenKey());
        }
    }

    protected abstract void saveAccessToken(ServerAccessToken var1);

    protected abstract void saveRefreshToken(ServerAccessToken var1, RefreshToken var2);

    protected abstract ServerAccessToken revokeAccessToken(String var1);

    protected abstract RefreshToken revokeRefreshToken(String var1);

    protected abstract RefreshToken getRefreshToken(String var1);

    public List<String> getDefaultScopes() {
        return this.defaultScopes;
    }

    public void setDefaultScopes(List<String> defaultScopes) {
        this.defaultScopes = defaultScopes;
    }

    public List<String> getRequiredScopes() {
        return this.requiredScopes;
    }

    public void setRequiredScopes(List<String> requiredScopes) {
        this.requiredScopes = requiredScopes;
    }

    public List<String> getInvisibleToClientScopes() {
        return this.invisibleToClientScopes;
    }

    public void setInvisibleToClientScopes(List<String> invisibleToClientScopes) {
        this.invisibleToClientScopes = invisibleToClientScopes;
    }

    public boolean isSupportPreauthorizedTokens() {
        return this.supportPreauthorizedTokens;
    }

    public void setSupportPreauthorizedTokens(boolean supportPreauthorizedTokens) {
        this.supportPreauthorizedTokens = supportPreauthorizedTokens;
    }
}

