/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.utils.crypto;

import java.security.Key;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;
import org.apache.cxf.rt.security.crypto.CryptoUtils;
import org.apache.cxf.rt.security.crypto.KeyProperties;

public final class ModelEncryptionSupport {
    public static final String SEP = "|";

    private ModelEncryptionSupport() {
    }

    public static String encryptClient(Client client, Key secretKey) throws SecurityException {
        return ModelEncryptionSupport.encryptClient(client, secretKey, null);
    }

    public static String encryptClient(Client client, Key secretKey, KeyProperties props) throws SecurityException {
        String tokenSequence = ModelEncryptionSupport.tokenizeClient(client);
        return CryptoUtils.encryptSequence((String)tokenSequence, (Key)secretKey, (KeyProperties)props);
    }

    public static String encryptAccessToken(ServerAccessToken token, Key secretKey) throws SecurityException {
        return ModelEncryptionSupport.encryptAccessToken(token, secretKey, null);
    }

    public static String encryptAccessToken(ServerAccessToken token, Key secretKey, KeyProperties props) throws SecurityException {
        String tokenSequence = ModelEncryptionSupport.tokenizeServerToken(token);
        return CryptoUtils.encryptSequence((String)tokenSequence, (Key)secretKey, (KeyProperties)props);
    }

    public static String encryptRefreshToken(RefreshToken token, Key secretKey) throws SecurityException {
        return ModelEncryptionSupport.encryptRefreshToken(token, secretKey, null);
    }

    public static String encryptRefreshToken(RefreshToken token, Key secretKey, KeyProperties props) throws SecurityException {
        String tokenSequence = ModelEncryptionSupport.tokenizeRefreshToken(token);
        return CryptoUtils.encryptSequence((String)tokenSequence, (Key)secretKey, (KeyProperties)props);
    }

    public static String encryptCodeGrant(ServerAuthorizationCodeGrant grant, Key secretKey) throws SecurityException {
        return ModelEncryptionSupport.encryptCodeGrant(grant, secretKey, null);
    }

    public static String encryptCodeGrant(ServerAuthorizationCodeGrant grant, Key secretKey, KeyProperties props) throws SecurityException {
        String tokenSequence = ModelEncryptionSupport.tokenizeCodeGrant(grant);
        return CryptoUtils.encryptSequence((String)tokenSequence, (Key)secretKey, (KeyProperties)props);
    }

    public static Client decryptClient(String encodedSequence, String encodedSecretKey) throws SecurityException {
        return ModelEncryptionSupport.decryptClient(encodedSequence, encodedSecretKey, new KeyProperties("AES"));
    }

    public static Client decryptClient(String encodedSequence, String encodedSecretKey, KeyProperties props) throws SecurityException {
        SecretKey key = CryptoUtils.decodeSecretKey((String)encodedSecretKey, (String)props.getKeyAlgo());
        return ModelEncryptionSupport.decryptClient(encodedSequence, key, props);
    }

    public static Client decryptClient(String encodedSequence, Key secretKey) throws SecurityException {
        return ModelEncryptionSupport.decryptClient(encodedSequence, secretKey, null);
    }

    public static Client decryptClient(String encodedData, Key secretKey, KeyProperties props) throws SecurityException {
        String decryptedSequence = CryptoUtils.decryptSequence((String)encodedData, (Key)secretKey, (KeyProperties)props);
        return ModelEncryptionSupport.recreateClient(decryptedSequence);
    }

    public static ServerAccessToken decryptAccessToken(OAuthDataProvider provider, String encodedToken, String encodedSecretKey) throws SecurityException {
        return ModelEncryptionSupport.decryptAccessToken(provider, encodedToken, encodedSecretKey, new KeyProperties("AES"));
    }

    public static ServerAccessToken decryptAccessToken(OAuthDataProvider provider, String encodedToken, String encodedSecretKey, KeyProperties props) throws SecurityException {
        SecretKey key = CryptoUtils.decodeSecretKey((String)encodedSecretKey, (String)props.getKeyAlgo());
        return ModelEncryptionSupport.decryptAccessToken(provider, encodedToken, key, props);
    }

    public static ServerAccessToken decryptAccessToken(OAuthDataProvider provider, String encodedToken, Key secretKey) throws SecurityException {
        return ModelEncryptionSupport.decryptAccessToken(provider, encodedToken, secretKey, null);
    }

    public static ServerAccessToken decryptAccessToken(OAuthDataProvider provider, String encodedData, Key secretKey, KeyProperties props) throws SecurityException {
        String decryptedSequence = CryptoUtils.decryptSequence((String)encodedData, (Key)secretKey, (KeyProperties)props);
        return ModelEncryptionSupport.recreateAccessToken(provider, encodedData, decryptedSequence);
    }

    public static RefreshToken decryptRefreshToken(OAuthDataProvider provider, String encodedToken, String encodedSecretKey) throws SecurityException {
        return ModelEncryptionSupport.decryptRefreshToken(provider, encodedToken, encodedSecretKey, new KeyProperties("AES"));
    }

    public static RefreshToken decryptRefreshToken(OAuthDataProvider provider, String encodedToken, String encodedSecretKey, KeyProperties props) throws SecurityException {
        SecretKey key = CryptoUtils.decodeSecretKey((String)encodedSecretKey, (String)props.getKeyAlgo());
        return ModelEncryptionSupport.decryptRefreshToken(provider, encodedToken, key, props);
    }

    public static RefreshToken decryptRefreshToken(OAuthDataProvider provider, String encodedToken, Key key) throws SecurityException {
        return ModelEncryptionSupport.decryptRefreshToken(provider, encodedToken, key, null);
    }

    public static RefreshToken decryptRefreshToken(OAuthDataProvider provider, String encodedData, Key key, KeyProperties props) throws SecurityException {
        String decryptedSequence = CryptoUtils.decryptSequence((String)encodedData, (Key)key, (KeyProperties)props);
        return ModelEncryptionSupport.recreateRefreshToken(provider, encodedData, decryptedSequence);
    }

    public static ServerAuthorizationCodeGrant decryptCodeGrant(OAuthDataProvider provider, String encodedToken, String encodedSecretKey) throws SecurityException {
        return ModelEncryptionSupport.decryptCodeGrant(provider, encodedToken, encodedSecretKey, new KeyProperties("AES"));
    }

    public static ServerAuthorizationCodeGrant decryptCodeGrant(OAuthDataProvider provider, String encodedToken, String encodedSecretKey, KeyProperties props) throws SecurityException {
        SecretKey key = CryptoUtils.decodeSecretKey((String)encodedSecretKey, (String)props.getKeyAlgo());
        return ModelEncryptionSupport.decryptCodeGrant(provider, encodedToken, key, props);
    }

    public static ServerAuthorizationCodeGrant decryptCodeGrant(OAuthDataProvider provider, String encodedToken, Key key) throws SecurityException {
        return ModelEncryptionSupport.decryptCodeGrant(provider, encodedToken, key, null);
    }

    public static ServerAuthorizationCodeGrant decryptCodeGrant(OAuthDataProvider provider, String encodedData, Key key, KeyProperties props) throws SecurityException {
        String decryptedSequence = CryptoUtils.decryptSequence((String)encodedData, (Key)key, (KeyProperties)props);
        return ModelEncryptionSupport.recreateCodeGrant(provider, decryptedSequence);
    }

    public static ServerAccessToken recreateAccessToken(OAuthDataProvider provider, String newTokenKey, String decryptedSequence) throws SecurityException {
        return ModelEncryptionSupport.recreateAccessToken(provider, newTokenKey, ModelEncryptionSupport.getParts(decryptedSequence));
    }

    public static RefreshToken recreateRefreshToken(OAuthDataProvider provider, String newTokenKey, String decryptedSequence) throws SecurityException {
        String[] parts = ModelEncryptionSupport.getParts(decryptedSequence);
        ServerAccessToken token = ModelEncryptionSupport.recreateAccessToken(provider, newTokenKey, parts);
        return new RefreshToken(token, newTokenKey, ModelEncryptionSupport.parseSimpleList(parts[parts.length - 1]));
    }

    public static ServerAuthorizationCodeGrant recreateCodeGrant(OAuthDataProvider provider, String decryptedSequence) throws SecurityException {
        return ModelEncryptionSupport.recreateCodeGrantInternal(provider, decryptedSequence);
    }

    public static Client recreateClient(String sequence) throws SecurityException {
        return ModelEncryptionSupport.recreateClientInternal(sequence);
    }

    private static ServerAccessToken recreateAccessToken(OAuthDataProvider provider, String newTokenKey, String[] parts) {
        ServerAccessToken newToken = new ServerAccessToken(provider.getClient(parts[4]), parts[1], newTokenKey == null ? parts[0] : newTokenKey, Long.valueOf(parts[2]), Long.valueOf(parts[3])){};
        newToken.setRefreshToken(ModelEncryptionSupport.getStringPart(parts[5]));
        newToken.setGrantType(ModelEncryptionSupport.getStringPart(parts[6]));
        newToken.setAudiences(ModelEncryptionSupport.parseSimpleList(parts[7]));
        newToken.setParameters(ModelEncryptionSupport.parseSimpleMap(parts[8]));
        if (!parts[9].trim().isEmpty()) {
            LinkedList<OAuthPermission> perms = new LinkedList<OAuthPermission>();
            String[] allPermParts = parts[9].split("\\.");
            int i = 0;
            while (i + 4 < allPermParts.length) {
                OAuthPermission perm = new OAuthPermission(allPermParts[i], allPermParts[i + 1]);
                perm.setDefault(Boolean.valueOf(allPermParts[i + 2]));
                perm.setHttpVerbs(ModelEncryptionSupport.parseSimpleList(allPermParts[i + 3]));
                perm.setUris(ModelEncryptionSupport.parseSimpleList(allPermParts[i + 4]));
                perms.add(perm);
                i += 5;
            }
            newToken.setScopes(perms);
        }
        newToken.setClientCodeVerifier(parts[10]);
        newToken.setSubject(ModelEncryptionSupport.recreateUserSubject(parts[11]));
        newToken.setExtraProperties(ModelEncryptionSupport.parseSimpleMap(parts[12]));
        return newToken;
    }

    private static String tokenizeRefreshToken(RefreshToken token) {
        String seq = ModelEncryptionSupport.tokenizeServerToken(token);
        return seq + SEP + token.getAccessTokens().toString();
    }

    private static String tokenizeServerToken(ServerAccessToken token) {
        StringBuilder state = new StringBuilder();
        state.append(ModelEncryptionSupport.tokenizeString(token.getTokenKey()));
        state.append(SEP);
        state.append(ModelEncryptionSupport.tokenizeString(token.getTokenType()));
        state.append(SEP);
        state.append(token.getExpiresIn());
        state.append(SEP);
        state.append(token.getIssuedAt());
        state.append(SEP);
        state.append(ModelEncryptionSupport.tokenizeString(token.getClient().getClientId()));
        state.append(SEP);
        state.append(ModelEncryptionSupport.tokenizeString(token.getRefreshToken()));
        state.append(SEP);
        state.append(ModelEncryptionSupport.tokenizeString(token.getGrantType()));
        state.append(SEP);
        state.append(token.getAudiences().toString());
        state.append(SEP);
        state.append(token.getParameters().toString());
        state.append(SEP);
        if (token.getScopes().isEmpty()) {
            state.append(" ");
        } else {
            for (OAuthPermission p : token.getScopes()) {
                state.append(ModelEncryptionSupport.tokenizeString(p.getPermission()));
                state.append(".");
                state.append(ModelEncryptionSupport.tokenizeString(p.getDescription()));
                state.append(".");
                state.append(p.isDefault());
                state.append(".");
                state.append(p.getHttpVerbs().toString());
                state.append(".");
                state.append(p.getUris().toString());
            }
        }
        state.append(SEP);
        state.append(ModelEncryptionSupport.tokenizeString(token.getClientCodeVerifier()));
        state.append(SEP);
        ModelEncryptionSupport.tokenizeUserSubject(state, token.getSubject());
        state.append(SEP);
        state.append(token.getExtraProperties().toString());
        return state.toString();
    }

    private static Client recreateClientInternal(String sequence) {
        String[] parts = ModelEncryptionSupport.getParts(sequence);
        Client c = new Client(parts[0], parts[1], Boolean.valueOf(parts[2]), ModelEncryptionSupport.getStringPart(parts[3]), ModelEncryptionSupport.getStringPart(parts[4]));
        c.setApplicationDescription(ModelEncryptionSupport.getStringPart(parts[5]));
        c.setApplicationLogoUri(ModelEncryptionSupport.getStringPart(parts[6]));
        c.setApplicationCertificates(ModelEncryptionSupport.parseSimpleList(parts[7]));
        c.setAllowedGrantTypes(ModelEncryptionSupport.parseSimpleList(parts[8]));
        c.setRedirectUris(ModelEncryptionSupport.parseSimpleList(parts[9]));
        c.setRegisteredScopes(ModelEncryptionSupport.parseSimpleList(parts[10]));
        c.setRegisteredAudiences(ModelEncryptionSupport.parseSimpleList(parts[11]));
        c.setProperties(ModelEncryptionSupport.parseSimpleMap(parts[12]));
        c.setSubject(ModelEncryptionSupport.recreateUserSubject(parts[13]));
        return c;
    }

    private static String tokenizeClient(Client client) {
        StringBuilder state = new StringBuilder();
        state.append(ModelEncryptionSupport.tokenizeString(client.getClientId()));
        state.append(SEP);
        state.append(ModelEncryptionSupport.tokenizeString(client.getClientSecret()));
        state.append(SEP);
        state.append(client.isConfidential());
        state.append(SEP);
        state.append(ModelEncryptionSupport.tokenizeString(client.getApplicationName()));
        state.append(SEP);
        state.append(ModelEncryptionSupport.tokenizeString(client.getApplicationWebUri()));
        state.append(SEP);
        state.append(ModelEncryptionSupport.tokenizeString(client.getApplicationDescription()));
        state.append(SEP);
        state.append(ModelEncryptionSupport.tokenizeString(client.getApplicationLogoUri()));
        state.append(SEP);
        state.append(client.getApplicationCertificates());
        state.append(SEP);
        state.append(client.getAllowedGrantTypes().toString());
        state.append(SEP);
        state.append(client.getRedirectUris().toString());
        state.append(SEP);
        state.append(client.getRegisteredScopes().toString());
        state.append(SEP);
        state.append(client.getRegisteredAudiences().toString());
        state.append(SEP);
        state.append(client.getProperties().toString());
        state.append(SEP);
        ModelEncryptionSupport.tokenizeUserSubject(state, client.getSubject());
        return state.toString();
    }

    private static ServerAuthorizationCodeGrant recreateCodeGrantInternal(OAuthDataProvider provider, String sequence) {
        String[] parts = ModelEncryptionSupport.getParts(sequence);
        ServerAuthorizationCodeGrant grant = new ServerAuthorizationCodeGrant(provider.getClient(parts[0]), parts[1], Long.valueOf(parts[2]), Long.valueOf(parts[3]));
        grant.setRedirectUri(ModelEncryptionSupport.getStringPart(parts[4]));
        grant.setAudience(ModelEncryptionSupport.getStringPart(parts[5]));
        grant.setClientCodeChallenge(ModelEncryptionSupport.getStringPart(parts[6]));
        grant.setApprovedScopes(ModelEncryptionSupport.parseSimpleList(parts[7]));
        grant.setSubject(ModelEncryptionSupport.recreateUserSubject(parts[8]));
        grant.setExtraProperties(ModelEncryptionSupport.parseSimpleMap(parts[9]));
        return grant;
    }

    private static String tokenizeCodeGrant(ServerAuthorizationCodeGrant grant) {
        StringBuilder state = new StringBuilder();
        state.append(grant.getClient().getClientId());
        state.append(SEP);
        state.append(ModelEncryptionSupport.tokenizeString(grant.getCode()));
        state.append(SEP);
        state.append(grant.getExpiresIn());
        state.append(SEP);
        state.append(grant.getIssuedAt());
        state.append(SEP);
        state.append(ModelEncryptionSupport.tokenizeString(grant.getRedirectUri()));
        state.append(SEP);
        state.append(ModelEncryptionSupport.tokenizeString(grant.getAudience()));
        state.append(SEP);
        state.append(ModelEncryptionSupport.tokenizeString(grant.getClientCodeChallenge()));
        state.append(SEP);
        state.append(grant.getApprovedScopes().toString());
        state.append(SEP);
        ModelEncryptionSupport.tokenizeUserSubject(state, grant.getSubject());
        state.append(SEP);
        state.append(grant.getExtraProperties().toString());
        return state.toString();
    }

    public static String getStringPart(String str) {
        return " ".equals(str) ? null : str;
    }

    private static String prepareSimpleString(String str) {
        return str.trim().isEmpty() ? "" : str.substring(1, str.length() - 1);
    }

    private static List<String> parseSimpleList(String listStr) {
        String pureStringList = ModelEncryptionSupport.prepareSimpleString(listStr);
        if (pureStringList.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(pureStringList.split(","));
    }

    public static Map<String, String> parseSimpleMap(String mapStr) {
        HashMap<String, String> props = new HashMap<String, String>();
        List<String> entries = ModelEncryptionSupport.parseSimpleList(mapStr);
        for (String entry : entries) {
            String[] pair = entry.split("=");
            props.put(pair[0], pair[1]);
        }
        return props;
    }

    public static String[] getParts(String sequence) {
        return sequence.split("\\|");
    }

    private static UserSubject recreateUserSubject(String sequence) {
        UserSubject subject = null;
        if (!sequence.trim().isEmpty()) {
            String[] subjectParts = sequence.split("\\.");
            subject = new UserSubject(ModelEncryptionSupport.getStringPart(subjectParts[0]), ModelEncryptionSupport.getStringPart(subjectParts[1]));
            subject.setRoles(ModelEncryptionSupport.parseSimpleList(subjectParts[2]));
            subject.setProperties(ModelEncryptionSupport.parseSimpleMap(subjectParts[3]));
        }
        return subject;
    }

    private static void tokenizeUserSubject(StringBuilder state, UserSubject subject) {
        if (subject != null) {
            state.append(ModelEncryptionSupport.tokenizeString(subject.getLogin()));
            state.append(".");
            state.append(ModelEncryptionSupport.tokenizeString(subject.getId()));
            state.append(".");
            state.append(subject.getRoles().toString());
            state.append(".");
            state.append(subject.getProperties().toString());
        } else {
            state.append(" ");
        }
    }

    public static String tokenizeString(String str) {
        return str != null ? str : " ";
    }
}

