/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.AbstractOAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;

public class JCacheOAuthDataProvider
extends AbstractOAuthDataProvider {
    public static final String CLIENT_CACHE_KEY = "cxf.oauth2.client.cache";
    public static final String ACCESS_TOKEN_CACHE_KEY = "cxf.oauth2.accesstoken.cache";
    public static final String REFRESH_TOKEN_CACHE_KEY = "cxf.oauth2.refreshtoken.cache";
    public static final String DEFAULT_CONFIG_URL = "cxf-oauth2-ehcache3.xml";
    protected final CacheManager cacheManager;
    private final Cache<String, Client> clientCache;
    private final Cache<String, ServerAccessToken> accessTokenCache;
    private final Cache<String, RefreshToken> refreshTokenCache;

    public JCacheOAuthDataProvider() throws Exception {
        this(DEFAULT_CONFIG_URL, BusFactory.getThreadDefaultBus((boolean)true));
    }

    public JCacheOAuthDataProvider(String configFileURL, Bus bus) throws Exception {
        this(configFileURL, bus, CLIENT_CACHE_KEY, ACCESS_TOKEN_CACHE_KEY, REFRESH_TOKEN_CACHE_KEY);
    }

    public JCacheOAuthDataProvider(String configFileURL, Bus bus, String clientCacheKey, String accessTokenKey, String refreshTokenKey) throws Exception {
        this.cacheManager = JCacheOAuthDataProvider.createCacheManager(configFileURL, bus);
        this.clientCache = JCacheOAuthDataProvider.createCache(this.cacheManager, clientCacheKey, String.class, Client.class);
        this.accessTokenCache = JCacheOAuthDataProvider.createCache(this.cacheManager, accessTokenKey, String.class, ServerAccessToken.class);
        this.refreshTokenCache = JCacheOAuthDataProvider.createCache(this.cacheManager, refreshTokenKey, String.class, RefreshToken.class);
    }

    @Override
    public Client getClient(String clientId) throws OAuthServiceException {
        return (Client)this.clientCache.get((Object)clientId);
    }

    @Override
    public void setClient(Client client) {
        this.clientCache.put((Object)client.getClientId(), (Object)client);
    }

    @Override
    protected void doRemoveClient(Client c) {
        this.clientCache.remove((Object)c.getClientId());
    }

    @Override
    public List<Client> getClients(UserSubject resourceOwner) {
        ArrayList<Client> clients = new ArrayList<Client>();
        for (Cache.Entry entry : this.clientCache) {
            Client client = (Client)entry.getValue();
            if (!JCacheOAuthDataProvider.isClientMatched(client, resourceOwner)) continue;
            clients.add(client);
        }
        return clients;
    }

    @Override
    public List<ServerAccessToken> getAccessTokens(Client c, UserSubject sub) {
        return JCacheOAuthDataProvider.getTokens(this.accessTokenCache, c, sub);
    }

    @Override
    public List<RefreshToken> getRefreshTokens(Client c, UserSubject sub) {
        return JCacheOAuthDataProvider.getTokens(this.refreshTokenCache, c, sub);
    }

    @Override
    public ServerAccessToken getAccessToken(String accessTokenKey) throws OAuthServiceException {
        return JCacheOAuthDataProvider.getToken(this.accessTokenCache, accessTokenKey);
    }

    @Override
    protected void doRevokeAccessToken(ServerAccessToken at) {
        this.accessTokenCache.remove((Object)at.getTokenKey());
    }

    @Override
    protected RefreshToken getRefreshToken(String refreshTokenKey) {
        return JCacheOAuthDataProvider.getToken(this.refreshTokenCache, refreshTokenKey);
    }

    @Override
    protected void doRevokeRefreshToken(RefreshToken rt) {
        this.refreshTokenCache.remove((Object)rt.getTokenKey());
    }

    @Override
    protected void saveAccessToken(ServerAccessToken serverToken) {
        this.accessTokenCache.put((Object)serverToken.getTokenKey(), (Object)serverToken);
    }

    @Override
    protected void saveRefreshToken(RefreshToken refreshToken) {
        this.refreshTokenCache.put((Object)refreshToken.getTokenKey(), (Object)refreshToken);
    }

    @Override
    public void close() {
        this.cacheManager.close();
    }

    protected static <K, V extends ServerAccessToken> V getToken(Cache<K, V> cache, K key) {
        ServerAccessToken token = (ServerAccessToken)cache.get(key);
        if (token != null && JCacheOAuthDataProvider.isExpired(token)) {
            cache.remove(key);
            token = null;
        }
        return (V)token;
    }

    protected static <K, V extends ServerAccessToken> List<V> getTokens(Cache<K, V> cache, Client client, UserSubject sub) {
        HashSet<Object> toRemove = new HashSet<Object>();
        ArrayList<ServerAccessToken> tokens = new ArrayList<ServerAccessToken>();
        for (Cache.Entry entry : cache) {
            ServerAccessToken token = (ServerAccessToken)entry.getValue();
            if (!JCacheOAuthDataProvider.isExpired(token)) {
                toRemove.add(entry.getKey());
                continue;
            }
            if (!JCacheOAuthDataProvider.isTokenMatched(token, client, sub)) continue;
            tokens.add(token);
        }
        cache.removeAll(toRemove);
        return tokens;
    }

    protected static boolean isExpired(ServerAccessToken token) {
        return System.currentTimeMillis() < token.getIssuedAt() + token.getExpiresIn();
    }

    protected static CacheManager createCacheManager(String configFile, Bus bus) throws Exception {
        URI configFileURI;
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus((boolean)true);
        }
        CachingProvider provider = Caching.getCachingProvider();
        try {
            configFileURI = ResourceUtils.getClasspathResourceURL((String)configFile, JCacheOAuthDataProvider.class, (Bus)bus).toURI();
        }
        catch (Exception ex) {
            configFileURI = provider.getDefaultURI();
        }
        return provider.getCacheManager(configFileURI, Thread.currentThread().getContextClassLoader());
    }

    protected static <K, V> Cache<K, V> createCache(CacheManager cacheManager, String cacheKey, Class<K> keyType, Class<V> valueType) {
        Cache cache = cacheManager.getCache(cacheKey, keyType, valueType);
        if (cache == null) {
            cache = cacheManager.createCache(cacheKey, (Configuration)new MutableConfiguration().setTypes(keyType, valueType).setStoreByValue(true).setStatisticsEnabled(false));
        }
        return cache;
    }
}

