/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.provider.ClientRegistrationProvider;
import org.apache.cxf.rs.security.oauth2.services.ClientRegistration;
import org.apache.cxf.rs.security.oauth2.services.ClientRegistrationResponse;
import org.apache.cxf.rs.security.oauth2.utils.AuthorizationUtils;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

@Path(value="register")
public class DynamicRegistrationService {
    private static final String DEFAULT_APPLICATION_TYPE = "web";
    private static final Integer DEFAULT_CLIENT_ID_SIZE = 10;
    private ClientRegistrationProvider clientProvider;
    private String initialAccessToken;
    private int clientIdSizeInBytes = DEFAULT_CLIENT_ID_SIZE;
    private MessageContext mc;
    private boolean supportRegistrationAccessTokens = true;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response register(ClientRegistration request) {
        this.checkInitialAccessToken();
        Client client = this.createNewClient(request);
        this.createRegAccessToken(client);
        this.clientProvider.setClient(client);
        return Response.status((int)201).entity((Object)this.fromClientToRegistrationResponse(client)).build();
    }

    protected void checkInitialAccessToken() {
        String accessToken;
        if (this.initialAccessToken != null && !this.initialAccessToken.equals(accessToken = this.getRequestAccessToken())) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
    }

    protected String createRegAccessToken(Client client) {
        String regAccessToken = OAuthUtils.generateRandomTokenKey();
        client.getProperties().put("registration_access_token", regAccessToken);
        return regAccessToken;
    }

    protected void checkRegistrationAccessToken(Client c, String accessToken) {
        String regAccessToken = c.getProperties().get("registration_access_token");
        if (!regAccessToken.equals(accessToken)) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
    }

    @GET
    @Produces(value={"application/json"})
    public ClientRegistration readClientRegistrationWithQuery(@QueryParam(value="client_id") String clientId) {
        return this.doReadClientRegistration(clientId);
    }

    @GET
    @Path(value="{clientId}")
    @Produces(value={"application/json"})
    public ClientRegistration readClientRegistrationWithPath(@PathParam(value="clientId") String clientId) {
        return this.doReadClientRegistration(clientId);
    }

    @PUT
    @Path(value="{clientId}")
    @Consumes(value={"application/json"})
    public Response updateClientRegistration(@PathParam(value="clientId") String clientId) {
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{clientId}")
    public Response deleteClientRegistration(@PathParam(value="clientId") String clientId) {
        if (this.readClient(clientId) != null) {
            this.clientProvider.removeClient(clientId);
        }
        return Response.ok().build();
    }

    protected ClientRegistrationResponse fromClientToRegistrationResponse(Client client) {
        ClientRegistrationResponse response = new ClientRegistrationResponse();
        response.setClientId(client.getClientId());
        response.setClientSecret(client.getClientSecret());
        response.setClientIdIssuedAt(client.getRegisteredAt());
        response.setClientSecretExpiresAt(0L);
        UriBuilder ub = this.getMessageContext().getUriInfo().getAbsolutePathBuilder();
        if (this.supportRegistrationAccessTokens) {
            response.setRegistrationClientUri(ub.path(client.getClientId()).build(new Object[0]).toString());
            response.setRegistrationAccessToken(client.getProperties().get("registration_access_token"));
        }
        return response;
    }

    protected ClientRegistration doReadClientRegistration(String clientId) {
        Client client = this.readClient(clientId);
        return this.fromClientToClientRegistration(client);
    }

    protected ClientRegistration fromClientToClientRegistration(Client c) {
        ClientRegistration reg = new ClientRegistration();
        reg.setClientName(c.getApplicationName());
        reg.setGrantTypes(c.getAllowedGrantTypes());
        reg.setApplicationType(c.isConfidential() ? DEFAULT_APPLICATION_TYPE : "native");
        reg.setRedirectUris(c.getRedirectUris());
        reg.setScope(OAuthUtils.convertListOfScopesToString(c.getRegisteredScopes()));
        if (c.getApplicationWebUri() != null) {
            reg.setClientUri(c.getApplicationWebUri());
        }
        if (c.getApplicationLogoUri() != null) {
            reg.setLogoUri(c.getApplicationLogoUri());
        }
        return reg;
    }

    protected Client readClient(String clientId) {
        String accessToken = this.getRequestAccessToken();
        Client c = this.clientProvider.getClient(clientId);
        if (c == null) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
        this.checkRegistrationAccessToken(c, accessToken);
        return c;
    }

    public String getInitialAccessToken() {
        return this.initialAccessToken;
    }

    public void setInitialAccessToken(String initialAccessToken) {
        this.initialAccessToken = initialAccessToken;
    }

    protected Client createNewClient(ClientRegistration request) {
        String clientLogoUri;
        String clientUri;
        String scope;
        String appType;
        List<String> grantTypes;
        String clientId = this.generateClientId();
        String clientName = request.getClientName();
        if (StringUtils.isEmpty((String)clientName)) {
            clientName = clientId;
        }
        if ((grantTypes = request.getGrantTypes()) == null) {
            grantTypes = Collections.singletonList("authorization_code");
        }
        if ((appType = request.getApplicationType()) == null) {
            appType = DEFAULT_APPLICATION_TYPE;
        }
        boolean isConfidential = DEFAULT_APPLICATION_TYPE.equals(appType) && grantTypes.contains("authorization_code");
        String clientSecret = isConfidential ? this.generateClientSecret(request) : null;
        Client newClient = new Client(clientId, clientSecret, isConfidential, clientName);
        newClient.setAllowedGrantTypes(grantTypes);
        newClient.setRegisteredAt(System.currentTimeMillis() / 1000L);
        List<String> redirectUris = request.getRedirectUris();
        if (redirectUris != null) {
            for (String uri : redirectUris) {
                this.validateRequestUri(uri, appType, grantTypes);
            }
            newClient.setRedirectUris(redirectUris);
        }
        if (!StringUtils.isEmpty((String)(scope = request.getScope()))) {
            newClient.setRegisteredScopes(OAuthUtils.parseScope(scope));
        }
        if ((clientUri = request.getClientUri()) != null) {
            newClient.setApplicationWebUri(clientUri);
        }
        if ((clientLogoUri = request.getLogoUri()) != null) {
            newClient.setApplicationLogoUri(clientLogoUri);
        }
        newClient.setRegisteredDynamically(true);
        return newClient;
    }

    protected void validateRequestUri(String uri, String appType, List<String> grantTypes) {
    }

    public void setClientProvider(ClientRegistrationProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    protected String generateClientId() {
        return Base64UrlUtility.encode((byte[])CryptoUtils.generateSecureRandomBytes((int)this.getClientIdSizeInBytes()));
    }

    public int getClientIdSizeInBytes() {
        return this.clientIdSizeInBytes;
    }

    public void setClientIdSizeInBytes(int size) {
        this.clientIdSizeInBytes = size;
    }

    protected String generateClientSecret(ClientRegistration request) {
        return Base64UrlUtility.encode((byte[])CryptoUtils.generateSecureRandomBytes((int)this.getClientSecretSizeInBytes(request)));
    }

    protected String getRequestAccessToken() {
        return AuthorizationUtils.getAuthorizationParts(this.getMessageContext(), Collections.singleton("Bearer"))[1];
    }

    protected int getClientSecretSizeInBytes(ClientRegistration request) {
        return 16;
    }

    @Context
    public void setMessageContext(MessageContext context) {
        this.mc = context;
    }

    public MessageContext getMessageContext() {
        return this.mc;
    }

    public void setSupportRegistrationAccessTokens(boolean supportRegistrationAccessTokens) {
        this.supportRegistrationAccessTokens = supportRegistrationAccessTokens;
    }
}

