/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.utils;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.rs.security.jose.jwt.JoseJwtConsumer;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.ClientRegistrationProvider;
import org.apache.cxf.rs.security.oauth2.tokens.bearer.BearerAccessToken;

public final class JwtTokenUtils {
    private JwtTokenUtils() {
    }

    public static String getClaimName(String tokenProperty, String defaultName, Map<String, String> claimsMap) {
        String claimName = null;
        if (claimsMap != null) {
            claimName = claimsMap.get(tokenProperty);
        }
        return claimName == null ? defaultName : claimName;
    }

    public static ServerAccessToken createAccessTokenFromJwt(JoseJwtConsumer consumer, String jose, ClientRegistrationProvider clientProvider, Map<String, String> claimsMap) {
        Map extraProperties;
        String codeVerifier;
        String grantCode;
        Object scope;
        String issuer;
        JwtClaims claims = consumer.getJwtToken(jose).getClaims();
        String clientIdClaimName = JwtTokenUtils.getClaimName("client_id", "client_id", claimsMap);
        String clientId = claims.getStringProperty(clientIdClaimName);
        Client c = clientProvider.getClient(clientId);
        long issuedAt = claims.getIssuedAt();
        long lifetime = claims.getExpiryTime() - issuedAt;
        BearerAccessToken at = new BearerAccessToken(c, jose, lifetime, issuedAt);
        List audiences = claims.getAudiences();
        if (audiences != null && !audiences.isEmpty()) {
            at.setAudiences(claims.getAudiences());
        }
        if ((issuer = claims.getIssuer()) != null) {
            at.setIssuer(issuer);
        }
        if ((scope = claims.getClaim("scope")) != null) {
            String[] scopes = scope instanceof String ? scope.toString().split(" ") : CastUtils.cast((List)((List)scope)).toArray(new String[0]);
            LinkedList<OAuthPermission> perms = new LinkedList<OAuthPermission>();
            for (String s : scopes) {
                if (StringUtils.isEmpty((String)s)) continue;
                perms.add(new OAuthPermission(s.trim()));
            }
            at.setScopes(perms);
        }
        String usernameProp = "username";
        String usernameClaimName = JwtTokenUtils.getClaimName("username", "username", claimsMap);
        String username = claims.getStringProperty(usernameClaimName);
        String subject = claims.getSubject();
        if (username != null) {
            UserSubject userSubject = new UserSubject(username);
            if (subject != null) {
                userSubject.setId(subject);
            }
            at.setSubject(userSubject);
        } else if (subject != null) {
            at.setSubject(new UserSubject(subject));
        }
        String grantType = claims.getStringProperty("grant_type");
        if (grantType != null) {
            at.setGrantType(grantType);
        }
        if ((grantCode = claims.getStringProperty("authorization_code")) != null) {
            at.setGrantCode(grantCode);
        }
        if ((codeVerifier = claims.getStringProperty("code_verifier")) != null) {
            at.setClientCodeVerifier(codeVerifier);
        }
        if ((extraProperties = CastUtils.cast((Map)((Map)claims.getClaim("extra_propertirs")))) != null) {
            at.getExtraProperties().putAll(extraProperties);
        }
        return at;
    }
}

