/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.idp;

import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.SecretKey;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweEncryption;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public abstract class AbstractJwsJweProducer {
    private JwsSignatureProvider sigProvider;
    private JweEncryptionProvider encryptionProvider;
    private boolean encryptWithClientCertificates;
    private boolean encryptWithClientSecret;
    private boolean signWithClientSecret;

    public void setSignatureProvider(JwsSignatureProvider signatureProvider) {
        this.sigProvider = signatureProvider;
    }

    protected JwsSignatureProvider getInitializedSigProvider(Client c, boolean required) {
        if (this.sigProvider != null) {
            return this.sigProvider;
        }
        if (this.signWithClientSecret) {
            byte[] hmac = CryptoUtils.decodeSequence((String)c.getClientSecret());
            return JwsUtils.getHmacSignatureProvider((byte[])hmac, (SignatureAlgorithm)SignatureAlgorithm.HS256);
        }
        return JwsUtils.loadSignatureProvider((boolean)required);
    }

    protected JweEncryptionProvider getInitializedEncryptionProvider(Client c, boolean required) {
        if (this.encryptionProvider != null) {
            return this.encryptionProvider;
        }
        JweEncryption theEncryptionProvider = null;
        if (this.encryptWithClientSecret) {
            SecretKey key = CryptoUtils.decodeSecretKey((String)c.getClientSecret());
            theEncryptionProvider = JweUtils.getDirectKeyJweEncryption((SecretKey)key, (ContentAlgorithm)ContentAlgorithm.A128GCM);
        } else if (this.encryptWithClientCertificates) {
            X509Certificate cert = (X509Certificate)CryptoUtils.decodeCertificate((String)((String)c.getApplicationCertificates().get(0)));
            theEncryptionProvider = JweUtils.createJweEncryptionProvider((RSAPublicKey)((RSAPublicKey)cert.getPublicKey()), (KeyAlgorithm)KeyAlgorithm.RSA_OAEP, (ContentAlgorithm)ContentAlgorithm.A128GCM, null);
        }
        if (theEncryptionProvider == null) {
            theEncryptionProvider = JweUtils.loadEncryptionProvider((boolean)required);
        }
        return theEncryptionProvider;
    }

    public void setEncryptWithClientCertificates(boolean encryptWithClientCertificates) {
        if (this.encryptWithClientSecret) {
            throw new SecurityException();
        }
        this.encryptWithClientCertificates = encryptWithClientCertificates;
    }

    public void setEncryptWithClientSecret(boolean encryptWithClientSecret) {
        if (this.signWithClientSecret || this.encryptWithClientCertificates) {
            throw new SecurityException();
        }
        this.encryptWithClientSecret = encryptWithClientSecret;
    }

    public void setSignWithClientSecret(boolean signWithClientSecret) {
        if (this.encryptWithClientSecret) {
            throw new SecurityException();
        }
        this.signWithClientSecret = signWithClientSecret;
    }
}

