/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.idp;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweJwtCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.oauth2.common.OAuthContext;
import org.apache.cxf.rs.security.oauth2.utils.OAuthContextUtils;
import org.apache.cxf.rs.security.oidc.common.UserInfo;
import org.apache.cxf.rs.security.oidc.idp.AbstractJwsJweProducer;
import org.apache.cxf.rs.security.oidc.idp.UserInfoProvider;

@Path(value="/userinfo")
public class UserInfoService
extends AbstractJwsJweProducer {
    private UserInfoProvider userInfoProvider;
    private String issuer;
    @Context
    private MessageContext mc;

    @GET
    @Produces(value={"application/json", "application/jwt"})
    public Response getUserInfo() {
        OAuthContext oauth = OAuthContextUtils.getContext((MessageContext)this.mc);
        UserInfo userInfo = this.userInfoProvider.getUserInfo(oauth.getClientId(), oauth.getSubject(), oauth.getPermissions());
        if (userInfo != null) {
            userInfo.setIssuer(this.issuer);
        }
        userInfo.setAudience(oauth.getClientId());
        Object responseEntity = userInfo;
        JwsJwtCompactProducer producer = new JwsJwtCompactProducer((JwtClaims)userInfo);
        JwsSignatureProvider theSigProvider = this.getInitializedSigProvider(null, false);
        JweEncryptionProvider theEncryptionProvider = this.getInitializedEncryptionProvider(null, false);
        if (theSigProvider != null) {
            String userInfoString = producer.signWith(theSigProvider);
            if (theEncryptionProvider != null) {
                userInfoString = theEncryptionProvider.encrypt(StringUtils.toBytesUTF8((String)userInfoString), null);
            }
            responseEntity = userInfoString;
        } else if (theEncryptionProvider != null) {
            JweJwtCompactProducer jwe = new JweJwtCompactProducer((JwtClaims)userInfo);
            responseEntity = jwe.encryptWith(theEncryptionProvider);
        }
        return Response.ok((Object)responseEntity).build();
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setUserInfoProvider(UserInfoProvider userInfoProvider) {
        this.userInfoProvider = userInfoProvider;
    }
}

