/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.rp;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;

public abstract class AbstractTokenValidator {
    private static final String SELF_ISSUED_ISSUER = "https://self-issued.me";
    private JweDecryptionProvider jweDecryptor;
    private JwsSignatureVerifier jwsVerifier;
    private String issuerId;
    private int issuedAtRange;
    private int clockOffset;
    private WebClient jwkSetClient;
    private boolean supportSelfIssuedProvider;
    private ConcurrentHashMap<String, JsonWebKey> keyMap = new ConcurrentHashMap();

    protected JwtToken getJwtToken(String wrappedJwtToken, boolean jweOnly) {
        if (wrappedJwtToken == null) {
            throw new SecurityException("ID Token is missing");
        }
        JweDecryptionProvider theJweDecryptor = this.getInitializedDecryptionProvider(jweOnly);
        if (theJweDecryptor != null) {
            if (jweOnly) {
                return new JweJwtCompactConsumer(wrappedJwtToken).decryptWith(this.jweDecryptor);
            }
            wrappedJwtToken = this.jweDecryptor.decrypt(wrappedJwtToken).getContentText();
        }
        JwsJwtCompactConsumer jwtConsumer = new JwsJwtCompactConsumer(wrappedJwtToken);
        JwtToken jwt = jwtConsumer.getJwtToken();
        JwsSignatureVerifier theSigVerifier = this.getInitializedSigVerifier(jwt);
        return this.validateToken(jwtConsumer, jwt, theSigVerifier);
    }

    protected void validateJwtClaims(JwtClaims claims, String clientId, boolean validateClaimsAlways) {
        String issuer = claims.getIssuer();
        if (issuer == null && validateClaimsAlways) {
            throw new SecurityException("Invalid provider");
        }
        if (!this.supportSelfIssuedProvider || this.issuerId != null || issuer == null || !SELF_ISSUED_ISSUER.equals(issuer)) {
            if (issuer != null && !issuer.equals(this.issuerId)) {
                throw new SecurityException("Invalid provider");
            }
            if (claims.getSubject() == null) {
                throw new SecurityException("Invalid subject");
            }
            String aud = claims.getAudience();
            if (aud == null && validateClaimsAlways || aud != null && !clientId.equals(aud)) {
                throw new SecurityException("Invalid audience");
            }
            JwtUtils.validateJwtTimeClaims((JwtClaims)claims, (int)this.clockOffset, (int)this.issuedAtRange, (boolean)validateClaimsAlways);
        }
    }

    protected JwtToken validateToken(JwsJwtCompactConsumer consumer, JwtToken jwt, JwsSignatureVerifier jws) {
        if (!consumer.verifySignatureWith(jws)) {
            throw new SecurityException("Invalid Signature");
        }
        return jwt;
    }

    public void setJweDecryptor(JweDecryptionProvider jweDecryptor) {
        this.jweDecryptor = jweDecryptor;
    }

    public void setJweVerifier(JwsSignatureVerifier theJwsVerifier) {
        this.jwsVerifier = theJwsVerifier;
    }

    public void setIssuerId(String issuerId) {
        this.issuerId = issuerId;
    }

    public void setJwkSetClient(WebClient jwkSetClient) {
        this.jwkSetClient = jwkSetClient;
    }

    public void setIssuedAtRange(int issuedAtRange) {
        this.issuedAtRange = issuedAtRange;
    }

    protected JweDecryptionProvider getInitializedDecryptionProvider(boolean jweOnly) {
        if (this.jweDecryptor != null) {
            return this.jweDecryptor;
        }
        return JweUtils.loadDecryptionProvider((boolean)jweOnly);
    }

    protected JwsSignatureVerifier getInitializedSigVerifier(JwtToken jwt) {
        if (this.jwsVerifier != null) {
            return this.jwsVerifier;
        }
        JwsSignatureVerifier theJwsVerifier = JwsUtils.loadSignatureVerifier((boolean)false);
        if (theJwsVerifier != null) {
            return theJwsVerifier;
        }
        JsonWebKey key = null;
        if (this.supportSelfIssuedProvider && SELF_ISSUED_ISSUER.equals(jwt.getClaim("issuer"))) {
            JsonWebKey publicKey;
            String thumbprint;
            String publicKeyJson = (String)jwt.getClaim("sub_jwk");
            if (publicKeyJson != null && (thumbprint = JwkUtils.getThumbprint((JsonWebKey)(publicKey = JwkUtils.readJwkKey((String)publicKeyJson)))).equals(jwt.getClaim("sub"))) {
                key = publicKey;
            }
            if (key == null) {
                throw new SecurityException("Self-issued JWK key is invalid or not available");
            }
        } else {
            String keyId = jwt.getHeaders().getKeyId();
            JsonWebKey jsonWebKey = key = keyId != null ? this.keyMap.get(keyId) : null;
            if (key == null) {
                if (this.jwkSetClient == null) {
                    throw new SecurityException("Provider Jwk Set Client is not available");
                }
                JsonWebKeys keys = (JsonWebKeys)this.jwkSetClient.get(JsonWebKeys.class);
                if (keyId != null) {
                    key = keys.getKey(keyId);
                } else if (keys.getKeys().size() == 1) {
                    key = (JsonWebKey)keys.getKeys().get(0);
                }
                this.keyMap.putAll(keys.getKeyIdMap());
            }
            if (key == null) {
                throw new SecurityException("JWK key with the key id: \"" + keyId + "\" is not available");
            }
        }
        if ((theJwsVerifier = JwsUtils.getSignatureVerifier((JsonWebKey)key)) == null) {
            throw new SecurityException("JWS Verifier is not available");
        }
        return theJwsVerifier;
    }

    public void setClockOffset(int clockOffset) {
        this.clockOffset = clockOffset;
    }

    public void setSupportSelfIssuedProvider(boolean supportSelfIssuedProvider) {
        this.supportSelfIssuedProvider = supportSelfIssuedProvider;
    }
}

