/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.rp;

import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.rp.AbstractTokenValidator;
import org.apache.cxf.rs.security.oidc.utils.OidcUtils;

public class IdTokenReader
extends AbstractTokenValidator {
    private boolean requireAtHash = true;

    public IdToken getIdToken(ClientAccessToken at, String clientId) {
        JwtToken jwt = this.getIdJwtToken(at, clientId);
        return this.getIdTokenFromJwt(jwt);
    }

    public IdToken getIdToken(String idJwtToken, String clientId) {
        JwtToken jwt = this.getIdJwtToken(idJwtToken, clientId);
        return this.getIdTokenFromJwt(jwt);
    }

    public JwtToken getIdJwtToken(ClientAccessToken at, String clientId) {
        String idJwtToken = (String)at.getParameters().get("id_token");
        JwtToken jwt = this.getIdJwtToken(idJwtToken, clientId);
        OidcUtils.validateAccessTokenHash(at, jwt, this.requireAtHash);
        return jwt;
    }

    public JwtToken getIdJwtToken(String idJwtToken, String clientId) {
        JwtToken jwt = this.getJwtToken(idJwtToken, false);
        this.validateJwtClaims(jwt.getClaims(), clientId, true);
        return jwt;
    }

    private IdToken getIdTokenFromJwt(JwtToken jwt) {
        return new IdToken(jwt.getClaims().asMap());
    }

    public void setRequireAtHash(boolean requireAtHash) {
        this.requireAtHash = requireAtHash;
    }
}

