/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.rp;

import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.oauth2.client.Consumer;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.rp.IdTokenReader;
import org.apache.cxf.rs.security.oidc.rp.OidcSecurityContext;

public class OidcIdTokenRequestFilter
implements ContainerRequestFilter {
    private String tokenFormParameter = "id_token";
    private IdTokenReader idTokenReader;
    private Consumer consumer;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        MultivaluedMap<String, String> form = this.toFormData(requestContext);
        String idTokenParamValue = (String)form.getFirst((Object)this.tokenFormParameter);
        if (idTokenParamValue == null) {
            requestContext.abortWith(Response.status((int)401).build());
            return;
        }
        IdToken idToken = this.idTokenReader.getIdToken(idTokenParamValue, this.consumer.getKey());
        JAXRSUtils.getCurrentMessage().setContent(IdToken.class, (Object)idToken);
        requestContext.setSecurityContext((SecurityContext)new OidcSecurityContext(idToken));
    }

    private MultivaluedMap<String, String> toFormData(ContainerRequestContext rc) {
        MetadataMap requestState = new MetadataMap();
        if (MediaType.APPLICATION_FORM_URLENCODED_TYPE.isCompatible(rc.getMediaType())) {
            String body = FormUtils.readBody((InputStream)rc.getEntityStream(), (String)"UTF-8");
            FormUtils.populateMapFromString((MultivaluedMap)requestState, (Message)JAXRSUtils.getCurrentMessage(), (String)body, (String)"UTF-8", (boolean)false);
        }
        return requestState;
    }

    public void setIdTokenReader(IdTokenReader idTokenReader) {
        this.idTokenReader = idTokenReader;
    }

    public void setTokenFormParameter(String tokenFormParameter) {
        this.tokenFormParameter = tokenFormParameter;
    }

    public void setConsumer(Consumer consumer) {
        this.consumer = consumer;
    }
}

