/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.rp;

import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContext;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContextManager;
import org.apache.cxf.rs.security.oidc.rp.OidcClientTokenContext;
import org.apache.cxf.rs.security.oidc.rp.OidcClientTokenContextImpl;
import org.apache.cxf.rs.security.oidc.rp.OidcSecurityContext;

@PreMatching
@Priority(value=1000)
public class OidcRpAuthenticationFilter
implements ContainerRequestFilter {
    @Context
    private MessageContext mc;
    private ClientTokenContextManager stateManager;
    private String redirectUri;

    public void filter(ContainerRequestContext rc) {
        if (this.checkSecurityContext(rc)) {
            return;
        }
        URI redirectAddress = null;
        if (this.redirectUri.startsWith("/")) {
            String basePath = (String)this.mc.get((Object)"http.base.path");
            redirectAddress = UriBuilder.fromUri((String)basePath).path(this.redirectUri).build(new Object[0]);
        } else if (this.redirectUri.startsWith("http")) {
            redirectAddress = URI.create(this.redirectUri);
        } else {
            UriBuilder ub = rc.getUriInfo().getBaseUriBuilder().path(this.redirectUri);
            redirectAddress = ub.build(new Object[0]);
        }
        rc.abortWith(Response.seeOther((URI)redirectAddress).header("Cache-Control", (Object)"no-cache, no-store").header("Pragma", (Object)"no-cache").build());
    }

    protected boolean checkSecurityContext(ContainerRequestContext rc) {
        OidcClientTokenContext tokenContext = (OidcClientTokenContext)this.stateManager.getClientTokenContext(this.mc);
        if (tokenContext == null) {
            return false;
        }
        OidcClientTokenContextImpl newTokenContext = new OidcClientTokenContextImpl();
        newTokenContext.setToken(tokenContext.getToken());
        newTokenContext.setIdToken(tokenContext.getIdToken());
        newTokenContext.setUserInfo(tokenContext.getUserInfo());
        newTokenContext.setState(this.toRequestState(rc));
        JAXRSUtils.getCurrentMessage().setContent(ClientTokenContext.class, (Object)newTokenContext);
        rc.setSecurityContext((SecurityContext)new OidcSecurityContext(newTokenContext));
        return true;
    }

    private MultivaluedMap<String, String> toRequestState(ContainerRequestContext rc) {
        MetadataMap requestState = new MetadataMap();
        requestState.putAll((Map)rc.getUriInfo().getQueryParameters(true));
        if (MediaType.APPLICATION_FORM_URLENCODED_TYPE.isCompatible(rc.getMediaType())) {
            String body = FormUtils.readBody((InputStream)rc.getEntityStream(), (String)"UTF-8");
            FormUtils.populateMapFromString((MultivaluedMap)requestState, (Message)JAXRSUtils.getCurrentMessage(), (String)body, (String)"UTF-8", (boolean)true);
        }
        return requestState;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setStateManager(ClientTokenContextManager stateManager) {
        this.stateManager = stateManager;
    }
}

