/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.rp;

import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContext;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContextManager;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.rp.OidcClientTokenContext;
import org.apache.cxf.rs.security.oidc.rp.OidcClientTokenContextImpl;

@Path(value="rp")
public class OidcRpAuthenticationService {
    private ClientTokenContextManager stateManager;
    private String defaultLocation;
    @Context
    private MessageContext mc;

    @POST
    @Path(value="signin")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response completeScriptAuthentication(@Context IdToken idToken) {
        OidcClientTokenContextImpl ctx = new OidcClientTokenContextImpl();
        ctx.setIdToken(idToken);
        return this.completeAuthentication(ctx);
    }

    @GET
    @Path(value="complete")
    public Response completeAuthentication(@Context OidcClientTokenContext oidcContext) {
        String location;
        this.stateManager.setClientTokenContext(this.mc, (ClientTokenContext)oidcContext);
        URI redirectUri = null;
        MultivaluedMap state = oidcContext.getState();
        String string = location = state != null ? (String)state.getFirst((Object)"state") : null;
        if (location == null && this.defaultLocation != null) {
            String basePath = (String)this.mc.get((Object)"http.base.path");
            redirectUri = UriBuilder.fromUri((String)basePath).path(this.defaultLocation).build(new Object[0]);
        } else if (location != null) {
            redirectUri = URI.create(location);
        }
        if (redirectUri != null) {
            return Response.seeOther((URI)redirectUri).build();
        }
        return Response.ok((Object)oidcContext).build();
    }

    public void setDefaultLocation(String defaultLocation) {
        this.defaultLocation = defaultLocation;
    }

    public void setStateManager(ClientTokenContextManager stateManager) {
        this.stateManager = stateManager;
    }
}

