/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.rp;

import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.common.security.SimpleSecurityContext;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.rp.OidcClientTokenContext;
import org.apache.cxf.rs.security.oidc.rp.OidcClientTokenContextImpl;

public class OidcSecurityContext
extends SimpleSecurityContext
implements SecurityContext {
    private OidcClientTokenContext oidcContext;

    public OidcSecurityContext(IdToken token) {
        this(new OidcClientTokenContextImpl(token));
    }

    public OidcSecurityContext(OidcClientTokenContext oidcContext) {
        super(OidcSecurityContext.getUserName(oidcContext));
        this.oidcContext = oidcContext;
    }

    public OidcClientTokenContext getOidcContext() {
        return this.oidcContext;
    }

    private static String getUserName(OidcClientTokenContext oidcContext) {
        if (oidcContext.getUserInfo() != null) {
            return oidcContext.getUserInfo().getEmail();
        }
        return oidcContext.getIdToken().getSubject();
    }

    public boolean isSecure() {
        String value = HttpUtils.getEndpointAddress((Message)JAXRSUtils.getCurrentMessage());
        return value.startsWith("https://");
    }

    public String getAuthenticationScheme() {
        return "OIDC";
    }
}

