/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.rp;

import javax.ws.rs.core.Form;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.common.UserInfo;
import org.apache.cxf.rs.security.oidc.rp.IdTokenReader;

public class UserInfoClient
extends IdTokenReader {
    private boolean encryptedOnly;
    private boolean sendTokenAsFormParameter;
    private WebClient profileClient;

    public UserInfo getUserInfo(ClientAccessToken at, IdToken idToken) {
        return this.getUserInfo(at, idToken, false);
    }

    public UserInfo getUserInfo(ClientAccessToken at, IdToken idToken, boolean asJwt) {
        if (!this.sendTokenAsFormParameter) {
            OAuthClientUtils.setAuthorizationHeader((WebClient)this.profileClient, (ClientAccessToken)at);
            if (asJwt) {
                String jwt = (String)this.profileClient.get(String.class);
                return this.getUserInfoFromJwt(jwt, idToken);
            }
            UserInfo profile = (UserInfo)((Object)this.profileClient.get(UserInfo.class));
            this.validateUserInfo(profile, idToken);
            return profile;
        }
        Form form = new Form().param("access_token", at.getTokenKey());
        if (asJwt) {
            String jwt = (String)this.profileClient.form(form).readEntity(String.class);
            return this.getUserInfoFromJwt(jwt, idToken);
        }
        UserInfo profile = (UserInfo)((Object)this.profileClient.form(form).readEntity(UserInfo.class));
        this.validateUserInfo(profile, idToken);
        return profile;
    }

    public UserInfo getUserInfoFromJwt(String profileJwtToken, IdToken idToken) {
        JwtToken jwt = this.getUserInfoJwt(profileJwtToken);
        return this.getUserInfoFromJwt(jwt, idToken);
    }

    public UserInfo getUserInfoFromJwt(JwtToken jwt, IdToken idToken) {
        UserInfo profile = new UserInfo(jwt.getClaims().asMap());
        this.validateUserInfo(profile, idToken);
        return profile;
    }

    public JwtToken getUserInfoJwt(String profileJwtToken) {
        return this.getJwtToken(profileJwtToken, this.encryptedOnly);
    }

    public void validateUserInfo(UserInfo profile, IdToken idToken) {
        this.validateJwtClaims(profile, idToken.getAudience(), false);
        if (!idToken.getSubject().equals(profile.getSubject())) {
            throw new SecurityException("Invalid subject");
        }
    }

    public void setEncryptedOnly(boolean encryptedOnly) {
        this.encryptedOnly = encryptedOnly;
    }

    public void setUserInfoServiceClient(WebClient client) {
        this.profileClient = client;
    }

    public void setSendTokenAsFormParameter(boolean sendTokenAsFormParameter) {
        this.sendTokenAsFormParameter = sendTokenAsFormParameter;
    }
}

