/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.utils;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rt.security.crypto.MessageDigestUtils;

public final class OidcUtils {
    public static final String ID_TOKEN = "id_token";
    public static final String OIDC_SCOPE = "oidc";
    public static final String PROFILE_SCOPE = "profile";
    public static final String EMAIL_SCOPE = "email";
    public static final String ADDRESS_SCOPE = "address";
    public static final String PHONE_SCOPE = "phone";
    public static final List<String> PROFILE_CLAIMS = Arrays.asList("name", "profile");
    public static final List<String> EMAIL_CLAIMS = Arrays.asList("email", "email_verified");
    public static final List<String> ADDRESS_CLAIMS = Arrays.asList("address");
    public static final List<String> PHONE_CLAIMS = Arrays.asList("phone_number");
    private static final Map<String, List<String>> SCOPES_MAP = new HashMap<String, List<String>>();

    private OidcUtils() {
    }

    public static String getOidcScope() {
        return OIDC_SCOPE;
    }

    public static String getProfileScope() {
        return OidcUtils.getScope(OIDC_SCOPE, PROFILE_SCOPE);
    }

    public static String getEmailScope() {
        return OidcUtils.getScope(OIDC_SCOPE, EMAIL_SCOPE);
    }

    public static String getAddressScope() {
        return OidcUtils.getScope(OIDC_SCOPE, ADDRESS_SCOPE);
    }

    public static String getPhoneScope() {
        return OidcUtils.getScope(OIDC_SCOPE, PHONE_SCOPE);
    }

    public static String getAllScopes() {
        return OidcUtils.getScope(OIDC_SCOPE, PROFILE_SCOPE, EMAIL_SCOPE, ADDRESS_SCOPE, PHONE_SCOPE);
    }

    public static List<String> getScopeProperties(String scope) {
        return SCOPES_MAP.get(scope);
    }

    private static String getScope(String ... scopes) {
        StringBuilder sb = new StringBuilder();
        for (String scope : scopes) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(scope);
        }
        return sb.toString();
    }

    public static void validateAccessTokenHash(ClientAccessToken at, JwtToken jwt) {
        OidcUtils.validateAccessTokenHash(at, jwt, true);
    }

    public static void validateAccessTokenHash(ClientAccessToken at, JwtToken jwt, boolean required) {
        OidcUtils.validateHash(at.getTokenKey(), (String)jwt.getClaims().getClaim("at_hash"), jwt.getHeaders().getAlgorithm(), required);
    }

    public static void validateCodeHash(String code, JwtToken jwt) {
        OidcUtils.validateCodeHash(code, jwt, true);
    }

    public static void validateCodeHash(String code, JwtToken jwt, boolean required) {
        OidcUtils.validateHash(code, (String)jwt.getClaims().getClaim("c_hash"), jwt.getHeaders().getAlgorithm(), required);
    }

    private static void validateHash(String value, String theHash, String joseAlgo, boolean required) {
        String hash = OidcUtils.calculateHash(value, joseAlgo);
        if (!hash.equals(theHash)) {
            throw new SecurityException("Invalid hash");
        }
    }

    public static String calculateHash(String value, String joseAlgo) {
        try {
            byte[] atBytes = StringUtils.toBytesASCII((String)value);
            byte[] digest = MessageDigestUtils.createDigest((byte[])atBytes, (String)"SHA-256");
            return Base64UrlUtility.encodeChunk((byte[])digest, (int)0, (int)16);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SecurityException(ex);
        }
    }

    static {
        SCOPES_MAP.put(PHONE_SCOPE, PHONE_CLAIMS);
        SCOPES_MAP.put(EMAIL_SCOPE, EMAIL_CLAIMS);
        SCOPES_MAP.put(ADDRESS_SCOPE, ADDRESS_CLAIMS);
        SCOPES_MAP.put(PROFILE_SCOPE, PROFILE_CLAIMS);
    }
}

