/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.common.CryptoLoader;
import org.apache.cxf.rs.security.common.SecurityUtils;
import org.apache.cxf.rs.security.saml.authorization.SecurityContextProvider;
import org.apache.cxf.rs.security.saml.authorization.SecurityContextProviderImpl;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SAMLKeyInfoProcessor;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.saml.WSSSAMLKeyInfoProcessor;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.SamlAssertionValidator;
import org.apache.wss4j.dom.validate.Validator;
import org.apache.xml.security.signature.XMLSignature;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@PreMatching
public abstract class AbstractSamlInHandler
implements ContainerRequestFilter {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractSamlInHandler.class);
    private Validator samlValidator = new SamlAssertionValidator();
    private SecurityContextProvider scProvider = new SecurityContextProviderImpl();

    public void setValidator(Validator validator) {
        this.samlValidator = validator;
    }

    public void setSecurityContextProvider(SecurityContextProvider p) {
        this.scProvider = p;
    }

    protected void validateToken(Message message, InputStream tokenStream) {
        Element token = this.readToken(message, tokenStream);
        this.validateToken(message, token);
    }

    protected Element readToken(Message message, InputStream tokenStream) {
        try {
            Document doc = StaxUtils.read((Reader)new InputStreamReader(tokenStream, "UTF-8"));
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            this.throwFault("Assertion can not be read as XML document", ex);
            return null;
        }
    }

    protected void validateToken(Message message, Element tokenElement) {
        this.validateToken(message, this.toWrapper(tokenElement));
    }

    protected SamlAssertionWrapper toWrapper(Element tokenElement) {
        try {
            return new SamlAssertionWrapper(tokenElement);
        }
        catch (Exception ex) {
            this.throwFault("Assertion can not be validated", ex);
            return null;
        }
    }

    protected void validateToken(Message message, SamlAssertionWrapper assertion) {
        try {
            RequestData data = new RequestData();
            if (assertion.isSigned()) {
                WSSConfig cfg = WSSConfig.getNewInstance();
                data.setWssConfig(cfg);
                data.setCallbackHandler(SecurityUtils.getCallbackHandler(message, this.getClass()));
                try {
                    data.setSigVerCrypto(new CryptoLoader().getCrypto(message, "ws-security.signature.crypto", "ws-security.signature.properties"));
                }
                catch (IOException ex) {
                    this.throwFault("Crypto can not be loaded", ex);
                }
                data.setEnableRevocation(MessageUtils.isTrue((Object)message.getContextualProperty("enableRevocation")));
                Signature sig = assertion.getSignature();
                KeyInfo keyInfo = sig.getKeyInfo();
                SAMLKeyInfo samlKeyInfo = SAMLUtil.getCredentialDirectlyFromKeyInfo((Element)keyInfo.getDOM(), (Crypto)data.getSigVerCrypto());
                assertion.verifySignature(samlKeyInfo);
                assertion.parseHOKSubject((SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(data, null), data.getSigVerCrypto(), data.getCallbackHandler());
            } else if (this.getTLSCertificates(message) == null) {
                this.throwFault("Assertion must be signed", null);
            }
            if (this.samlValidator != null) {
                Credential credential = new Credential();
                credential.setSamlAssertion(assertion);
                this.samlValidator.validate(credential, data);
            }
            this.checkSubjectConfirmationData(message, assertion);
            this.setSecurityContext(message, assertion);
        }
        catch (Exception ex) {
            this.throwFault("Assertion can not be validated", ex);
        }
    }

    protected void checkSubjectConfirmationData(Message message, SamlAssertionWrapper assertion) {
        Certificate[] tlsCerts = this.getTLSCertificates(message);
        if (!this.checkHolderOfKey(message, assertion, tlsCerts)) {
            this.throwFault("Holder Of Key claim fails", null);
        }
        if (!this.checkSenderVouches(message, assertion, tlsCerts)) {
            this.throwFault("Sender vouchers claim fails", null);
        }
        if (!this.checkBearer(assertion, tlsCerts)) {
            this.throwFault("Bearer claim fails", null);
        }
    }

    protected void setSecurityContext(Message message, SamlAssertionWrapper wrapper) {
        if (this.scProvider != null) {
            SecurityContext sc = this.scProvider.getSecurityContext(message, wrapper);
            message.put(SecurityContext.class, (Object)sc);
        }
    }

    private Certificate[] getTLSCertificates(Message message) {
        TLSSessionInfo tlsInfo = (TLSSessionInfo)message.get(TLSSessionInfo.class);
        return tlsInfo != null ? tlsInfo.getPeerCertificates() : null;
    }

    protected void throwFault(String error, Exception ex) {
        LOG.warning(error);
        Response response = Response.status((int)401).entity((Object)error).build();
        throw ex != null ? new NotAuthorizedException(response, (Throwable)ex) : new NotAuthorizedException(response);
    }

    protected boolean checkSenderVouches(Message message, SamlAssertionWrapper assertionWrapper, Certificate[] tlsCerts) {
        if (tlsCerts != null && tlsCerts.length > 0) {
            return true;
        }
        List confirmationMethods = assertionWrapper.getConfirmationMethods();
        for (String confirmationMethod : confirmationMethods) {
            if (!OpenSAMLUtil.isMethodSenderVouches((String)confirmationMethod)) continue;
            Element signedElement = (Element)message.getContent(Element.class);
            Node assertionParent = assertionWrapper.getElement().getParentNode();
            if (assertionParent == signedElement) continue;
            XMLSignature signature = (XMLSignature)message.getContent(XMLSignature.class);
            if (signature == null) {
                return false;
            }
            SAMLKeyInfo subjectKeyInfo = assertionWrapper.getSignatureKeyInfo();
            if (this.compareCredentials(subjectKeyInfo, signature, tlsCerts)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkHolderOfKey(Message message, SamlAssertionWrapper assertionWrapper, Certificate[] tlsCerts) {
        List confirmationMethods = assertionWrapper.getConfirmationMethods();
        for (String confirmationMethod : confirmationMethods) {
            if (!OpenSAMLUtil.isMethodHolderOfKey((String)confirmationMethod)) continue;
            XMLSignature sig = (XMLSignature)message.getContent(XMLSignature.class);
            SAMLKeyInfo subjectKeyInfo = assertionWrapper.getSubjectKeyInfo();
            if (this.compareCredentials(subjectKeyInfo, sig, tlsCerts)) continue;
            return false;
        }
        return true;
    }

    private boolean compareCredentials(SAMLKeyInfo subjectKeyInfo, XMLSignature sig, Certificate[] tlsCerts) {
        X509Certificate[] subjectCerts = subjectKeyInfo.getCerts();
        PublicKey subjectPublicKey = subjectKeyInfo.getPublicKey();
        if (tlsCerts != null && tlsCerts.length > 0 && subjectCerts != null && subjectCerts.length > 0 && tlsCerts[0].equals(subjectCerts[0])) {
            return true;
        }
        if (tlsCerts != null && tlsCerts.length > 0 && subjectPublicKey != null && tlsCerts[0].getPublicKey().equals(subjectPublicKey)) {
            return true;
        }
        if (sig == null) {
            return false;
        }
        try {
            X509Certificate[] certs = new X509Certificate[]{sig.getKeyInfo().getX509Certificate()};
            PublicKey publicKey = sig.getKeyInfo().getPublicKey();
            if (certs != null && certs.length > 0 && subjectCerts != null && subjectCerts.length > 0 && certs[0].equals(subjectCerts[0])) {
                return true;
            }
            if (publicKey != null && publicKey.equals(subjectPublicKey)) {
                return true;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return false;
    }

    protected boolean checkBearer(SamlAssertionWrapper assertionWrapper, Certificate[] tlsCerts) {
        List confirmationMethods = assertionWrapper.getConfirmationMethods();
        for (String confirmationMethod : confirmationMethods) {
            boolean isBearer = this.isMethodBearer(confirmationMethod);
            if (!isBearer || assertionWrapper.isSigned() || tlsCerts != null && tlsCerts.length != 0) continue;
            return false;
        }
        return true;
    }

    private boolean isMethodBearer(String confirmMethod) {
        return confirmMethod != null && confirmMethod.startsWith("urn:oasis:names:tc:SAML:") && confirmMethod.endsWith(":cm:bearer");
    }

    static {
        WSSConfig.init();
    }
}

