/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.xml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Logger;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.wss4j.dom.WSSConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractXmlSecInHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractXmlSecInHandler.class);
    private boolean allowEmptyBody;

    public void setAllowEmptyBody(boolean allow) {
        this.allowEmptyBody = allow;
    }

    protected Document getDocument(Message message) {
        String method = (String)message.get((Object)"org.apache.cxf.request.method");
        if ("GET".equals(method)) {
            return null;
        }
        Document doc = null;
        InputStream is = (InputStream)message.getContent(InputStream.class);
        if (is != null) {
            try {
                doc = StaxUtils.read((Reader)new InputStreamReader(is, "UTF-8"));
            }
            catch (Exception ex) {
                this.throwFault("Invalid XML payload", ex);
            }
        } else {
            XMLStreamReader reader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
            if (reader instanceof W3CDOMStreamReader) {
                doc = ((W3CDOMStreamReader)reader).getDocument();
            }
        }
        if (doc == null && !this.allowEmptyBody) {
            this.throwFault("No payload is available", null);
        }
        return doc;
    }

    protected void throwFault(String error, Exception ex) {
        LOG.warning(error);
        Response response = Response.status((int)400).entity((Object)error).build();
        throw ex != null ? new BadRequestException(response, (Throwable)ex) : new BadRequestException(response);
    }

    protected Element getNode(Element parent, String ns, String name, int index) {
        NodeList list = parent.getElementsByTagNameNS(ns, name);
        if (list != null && list.getLength() >= index + 1) {
            return (Element)list.item(index);
        }
        return null;
    }

    static {
        WSSConfig.init();
    }
}

