/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.xml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.wss4j.common.crypto.WSProviderConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractXmlSecInHandler {
    public static final String SIGNING_CERT = "xml.security.signing.cert";
    public static final String SIGNING_PUBLIC_KEY = "xml.security.signing.public.key";
    protected static final String SIG_NS = "http://www.w3.org/2000/09/xmldsig#";
    protected static final String SIG_PREFIX = "ds";
    protected static final String ENC_NS = "http://www.w3.org/2001/04/xmlenc#";
    protected static final String ENC_PREFIX = "xenc";
    protected static final String WSU_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractXmlSecInHandler.class);
    private boolean allowEmptyBody;

    public void setAllowEmptyBody(boolean allow) {
        this.allowEmptyBody = allow;
    }

    protected Document getDocument(Message message) {
        String method = (String)message.get((Object)"org.apache.cxf.request.method");
        if ("GET".equals(method)) {
            return null;
        }
        Document doc = null;
        InputStream is = (InputStream)message.getContent(InputStream.class);
        if (is != null) {
            try {
                doc = StaxUtils.read((Reader)new InputStreamReader(is, "UTF-8"));
            }
            catch (Exception ex) {
                this.throwFault("Invalid XML payload", ex);
            }
        } else {
            XMLStreamReader reader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
            if (reader instanceof W3CDOMStreamReader) {
                doc = ((W3CDOMStreamReader)reader).getDocument();
            }
        }
        if (doc == null && !this.allowEmptyBody) {
            this.throwFault("No payload is available", null);
        }
        return doc;
    }

    protected void throwFault(String error, Exception ex) {
        LOG.warning(error);
        Response response = JAXRSUtils.toResponseBuilder((int)400).entity((Object)error).build();
        throw ExceptionUtils.toBadRequestException(null, (Response)response);
    }

    protected Element getNode(Element parent, String ns, String name, int index) {
        NodeList list = parent.getElementsByTagNameNS(ns, name);
        if (list != null && list.getLength() >= index + 1) {
            return (Element)list.item(index);
        }
        return null;
    }

    static {
        WSProviderConfig.init();
    }
}

