/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.xml;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;

public final class EncryptionUtils {
    private EncryptionUtils() {
    }

    public static Cipher initCipherWithCert(String keyEncAlgo, int mode, X509Certificate cert) throws WSSecurityException {
        return EncryptionUtils.initCipherWithCert(keyEncAlgo, null, mode, cert);
    }

    public static Cipher initCipherWithCert(String keyEncAlgo, String digestAlg, int mode, X509Certificate cert) throws WSSecurityException {
        Cipher cipher = KeyUtils.getCipherInstance((String)keyEncAlgo);
        try {
            OAEPParameterSpec oaepParameters = EncryptionUtils.constructOAEPParameters(keyEncAlgo, digestAlg, null, null);
            if (oaepParameters == null) {
                cipher.init(mode, cert);
            } else {
                cipher.init(mode, (Key)cert.getPublicKey(), oaepParameters);
            }
        }
        catch (InvalidKeyException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, null, null, new Object[]{e});
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, null, null, new Object[]{e});
        }
        return cipher;
    }

    public static Cipher initCipherWithKey(String keyEncAlgo, int mode, Key key) throws WSSecurityException {
        return EncryptionUtils.initCipherWithKey(keyEncAlgo, null, mode, key);
    }

    public static Cipher initCipherWithKey(String keyEncAlgo, String digestAlgo, int mode, Key key) throws WSSecurityException {
        Cipher cipher = KeyUtils.getCipherInstance((String)keyEncAlgo);
        try {
            OAEPParameterSpec oaepParameters = EncryptionUtils.constructOAEPParameters(keyEncAlgo, digestAlgo, null, null);
            if (oaepParameters == null) {
                cipher.init(mode, key);
            } else {
                cipher.init(mode, key, oaepParameters);
            }
        }
        catch (InvalidKeyException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, null, null, new Object[]{e});
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, null, null, new Object[]{e});
        }
        return cipher;
    }

    public static OAEPParameterSpec constructOAEPParameters(String encryptionAlgorithm, String digestAlgorithm, String mgfAlgorithm, byte[] oaepParams) {
        if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(encryptionAlgorithm) || "http://www.w3.org/2009/xmlenc11#rsa-oaep".equals(encryptionAlgorithm)) {
            String jceDigestAlgorithm = "SHA-1";
            if (digestAlgorithm != null) {
                jceDigestAlgorithm = JCEMapper.translateURItoJCEID((String)digestAlgorithm);
            }
            PSource.PSpecified pSource = PSource.PSpecified.DEFAULT;
            if (oaepParams != null) {
                pSource = new PSource.PSpecified(oaepParams);
            }
            MGF1ParameterSpec mgfParameterSpec = new MGF1ParameterSpec("SHA-1");
            if ("http://www.w3.org/2009/xmlenc11#rsa-oaep".equals(encryptionAlgorithm)) {
                if ("http://www.w3.org/2009/xmlenc11#mgf1sha256".equals(mgfAlgorithm)) {
                    mgfParameterSpec = new MGF1ParameterSpec("SHA-256");
                } else if ("http://www.w3.org/2009/xmlenc11#mgf1sha384".equals(mgfAlgorithm)) {
                    mgfParameterSpec = new MGF1ParameterSpec("SHA-384");
                } else if ("http://www.w3.org/2009/xmlenc11#mgf1sha512".equals(mgfAlgorithm)) {
                    mgfParameterSpec = new MGF1ParameterSpec("SHA-512");
                }
            }
            return new OAEPParameterSpec(jceDigestAlgorithm, "MGF1", mgfParameterSpec, pSource);
        }
        return null;
    }

    public static XMLCipher initXMLCipher(String symEncAlgo, int mode, Key key) throws WSSecurityException {
        try {
            XMLCipher cipher = XMLCipher.getInstance((String)symEncAlgo);
            cipher.setSecureValidation(true);
            cipher.init(mode, key);
            return cipher;
        }
        catch (XMLEncryptionException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)((Object)ex));
        }
    }
}

