/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.rs.security.saml.DeflateEncoderDecoder;
import org.apache.cxf.rs.security.saml.SAMLUtils;
import org.apache.wss4j.common.crypto.WSProviderConfig;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;

public abstract class AbstractSamlOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private boolean useDeflateEncoding = true;

    protected AbstractSamlOutInterceptor(String phase) {
        super(phase);
    }

    public void setUseDeflateEncoding(boolean deflate) {
        this.useDeflateEncoding = deflate;
    }

    protected SamlAssertionWrapper createAssertion(Message message) throws Fault {
        return SAMLUtils.createAssertion(message);
    }

    protected String encodeToken(String assertion) throws Base64Exception {
        byte[] tokenBytes = null;
        try {
            tokenBytes = assertion.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        if (this.useDeflateEncoding) {
            tokenBytes = new DeflateEncoderDecoder().deflateToken(tokenBytes);
        }
        StringWriter writer = new StringWriter();
        Base64Utility.encode((byte[])tokenBytes, (int)0, (int)tokenBytes.length, (Writer)writer);
        return writer.toString();
    }

    static {
        WSProviderConfig.init();
    }
}

