/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.openapi;

import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.doc.DocumentationProvider;
import org.apache.cxf.jaxrs.model.doc.JavaDocProvider;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;

public class OpenApiCustomizer {
    protected boolean dynamicBasePath;
    protected boolean replaceTags;
    protected DocumentationProvider javadocProvider;
    protected List<ClassResourceInfo> cris;
    protected String applicationPath;

    public OpenAPIConfiguration customize(OpenAPIConfiguration configuration) {
        if (configuration == null) {
            return configuration;
        }
        if (this.dynamicBasePath) {
            MessageContext ctx = this.createMessageContext();
            String url = StringUtils.removeEnd((String)StringUtils.substringBeforeLast((String)ctx.getUriInfo().getRequestUri().toString(), (String)"/"), (String)this.applicationPath);
            List servers = configuration.getOpenAPI().getServers();
            if (servers == null || servers.stream().noneMatch(s -> s.getUrl().equalsIgnoreCase(url))) {
                configuration.getOpenAPI().setServers(Collections.singletonList(new Server().url(url)));
            }
        }
        return configuration;
    }

    protected String extractJavadoc(Operation operation, OperationResourceInfo ori, int paramIdx) {
        String javadoc = null;
        if (operation.getParameters().size() == ori.getParameters().size()) {
            javadoc = this.javadocProvider.getMethodParameterDoc(ori, paramIdx);
        } else {
            for (int j = 0; j < ori.getParameters().size(); ++j) {
                if (!Objects.equals(((Parameter)operation.getParameters().get(paramIdx)).getName(), ((org.apache.cxf.jaxrs.model.Parameter)ori.getParameters().get(j)).getName())) continue;
                javadoc = this.javadocProvider.getMethodParameterDoc(ori, j);
            }
        }
        return javadoc;
    }

    public void customize(OpenAPI oas) {
        if (this.replaceTags || this.javadocProvider != null) {
            HashMap operations = new HashMap();
            HashMap methods = new HashMap();
            this.cris.forEach(cri -> cri.getMethodDispatcher().getOperationResourceInfos().forEach(ori -> {
                String normalizedPath = this.getNormalizedPath(cri.getURITemplate().getValue(), ori.getURITemplate().getValue());
                operations.put(normalizedPath, cri);
                methods.put(Pair.of((Object)ori.getHttpMethod(), (Object)normalizedPath), ori);
            }));
            ArrayList tags = new ArrayList();
            oas.getPaths().forEach((pathKey, pathItem) -> {
                Optional<Object> tag;
                if (this.replaceTags && operations.containsKey(pathKey)) {
                    ClassResourceInfo cri = (ClassResourceInfo)operations.get(pathKey);
                    tag = Optional.of(new Tag());
                    ((Tag)tag.get()).setName(cri.getURITemplate().getValue().replaceAll("/", "_"));
                    if (this.javadocProvider != null) {
                        ((Tag)tag.get()).setDescription(this.javadocProvider.getClassDoc(cri));
                    }
                    if (!tags.contains(tag.get())) {
                        tags.add(tag.get());
                    }
                } else {
                    tag = Optional.empty();
                }
                pathItem.readOperationsMap().forEach((method, operation) -> {
                    Pair key;
                    if (this.replaceTags && tag.isPresent()) {
                        operation.setTags(Collections.singletonList(((Tag)tag.get()).getName()));
                    }
                    if (methods.containsKey(key = Pair.of((Object)method.name(), (Object)pathKey)) && this.javadocProvider != null) {
                        OperationResourceInfo ori = (OperationResourceInfo)methods.get(key);
                        if (StringUtils.isBlank((CharSequence)operation.getSummary())) {
                            operation.setSummary(this.javadocProvider.getMethodDoc(ori));
                        }
                        if (operation.getParameters() == null) {
                            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
                            this.addParameters(parameters);
                            operation.setParameters(parameters);
                        }
                        for (int i = 0; i < operation.getParameters().size(); ++i) {
                            if (!StringUtils.isBlank((CharSequence)((Parameter)operation.getParameters().get(i)).getDescription())) continue;
                            ((Parameter)operation.getParameters().get(i)).setDescription(this.extractJavadoc((Operation)operation, ori, i));
                        }
                        this.addParameters(operation.getParameters());
                        this.customizeResponses((Operation)operation, ori);
                    }
                });
            });
            if (this.replaceTags && oas.getTags() != null) {
                oas.setTags(tags);
            }
        }
    }

    protected String getNormalizedPath(String classResourcePath, String operationResourcePath) {
        String[] segments;
        StringBuilder normalizedPath = new StringBuilder();
        for (String segment : segments = StringUtils.split((String)(classResourcePath + operationResourcePath), (String)"/")) {
            if (StringUtils.isEmpty((CharSequence)segment)) continue;
            normalizedPath.append("/").append(segment);
        }
        if (normalizedPath.toString().endsWith(":.*}")) {
            normalizedPath.setLength(normalizedPath.length() - 4);
            normalizedPath.append('}');
        }
        return "".equals(normalizedPath.toString()) ? "/" : normalizedPath.toString();
    }

    protected void addParameters(List<Parameter> parameters) {
    }

    protected void customizeResponses(Operation operation, OperationResourceInfo ori) {
        ApiResponse response;
        if (operation.getResponses() != null && !operation.getResponses().isEmpty() && (StringUtils.isBlank((CharSequence)(response = (ApiResponse)((Map.Entry)operation.getResponses().entrySet().iterator().next()).getValue()).getDescription()) || StringUtils.isNotBlank((CharSequence)this.javadocProvider.getMethodResponseDoc(ori)) && "default response".equals(response.getDescription()))) {
            response.setDescription(this.javadocProvider.getMethodResponseDoc(ori));
        }
    }

    public void setDynamicBasePath(boolean dynamicBasePath) {
        this.dynamicBasePath = dynamicBasePath;
    }

    public void setReplaceTags(boolean replaceTags) {
        this.replaceTags = replaceTags;
    }

    public void setJavadocProvider(DocumentationProvider javadocProvider) {
        this.javadocProvider = javadocProvider;
    }

    public void setClassResourceInfos(List<ClassResourceInfo> classResourceInfos) {
        this.cris = classResourceInfos;
    }

    public void setJavaDocPath(String javaDocPath) throws Exception {
        this.javadocProvider = new JavaDocProvider(javaDocPath);
    }

    public void setJavaDocPaths(String ... javaDocPaths) throws Exception {
        this.javadocProvider = new JavaDocProvider(javaDocPaths);
    }

    public void setJavaDocURLs(URL[] javaDocURLs) {
        this.javadocProvider = new JavaDocProvider(javaDocURLs);
    }

    public void setApplicationInfo(ApplicationInfo application) {
        Class<?> clazz;
        ApplicationPath path;
        if (application != null && application.getProvider() != null && (path = ResourceUtils.locateApplicationPath(clazz = ((Application)application.getProvider()).getClass())) != null) {
            this.applicationPath = path.value();
            if (!this.applicationPath.startsWith("/")) {
                this.applicationPath = "/" + this.applicationPath;
            }
            if (this.applicationPath.endsWith("/")) {
                this.applicationPath = this.applicationPath.substring(0, this.applicationPath.lastIndexOf("/"));
            }
        }
    }

    protected MessageContext createMessageContext() {
        return (MessageContext)JAXRSUtils.createContextValue((Message)JAXRSUtils.getCurrentMessage(), null, MessageContext.class);
    }
}

