/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.openapi.parse;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.UserApplication;
import org.apache.cxf.jaxrs.model.UserOperation;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.jaxrs.openapi.parse.ParseConfiguration;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

public final class OpenApiParseUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(ResourceUtils.class);
    private static final Map<String, Class<?>> OPENAPI_TYPE_MAP = new HashMap();

    private OpenApiParseUtils() {
    }

    public static UserApplication getUserApplication(String loc) {
        return OpenApiParseUtils.getUserApplication(loc, BusFactory.getThreadDefaultBus());
    }

    public static UserApplication getUserApplication(String loc, Bus bus) {
        return OpenApiParseUtils.getUserApplication(loc, bus, new ParseConfiguration());
    }

    public static UserApplication getUserApplication(String loc, Bus bus, ParseConfiguration cfg) {
        try {
            InputStream is = ResourceUtils.getResourceStream((String)loc, (Bus)bus);
            if (is == null) {
                return null;
            }
            return OpenApiParseUtils.getUserApplicationFromStream(is, cfg);
        }
        catch (Exception ex) {
            LOG.warning("Problem with processing a user model at " + loc);
            return null;
        }
    }

    public static UserApplication getUserApplicationFromStream(InputStream is) throws IOException {
        return OpenApiParseUtils.getUserApplicationFromStream(is, new ParseConfiguration());
    }

    public static UserApplication getUserApplicationFromStream(InputStream is, ParseConfiguration cfg) throws IOException {
        return OpenApiParseUtils.getUserApplicationFromJson(IOUtils.readStringFromStream((InputStream)is), cfg);
    }

    public static UserApplication getUserApplicationFromJson(String json) {
        return OpenApiParseUtils.getUserApplicationFromJson(json, new ParseConfiguration());
    }

    public static UserApplication getUserApplicationFromJson(String json, ParseConfiguration cfg) {
        String url;
        JsonMapObjectReaderWriter reader = new JsonMapObjectReaderWriter();
        Map map = reader.fromJson(json);
        UserApplication app = new UserApplication();
        app.setBasePath("/");
        List servers = CastUtils.cast((List)((List)map.get("servers")));
        if (servers != null && !servers.isEmpty() && (url = (String)((Map)servers.get(0)).get("url")) != null) {
            app.setBasePath(url);
        }
        LinkedHashMap userOpsMap = new LinkedHashMap();
        HashSet<String> tags = new HashSet<String>();
        List tagsProp = CastUtils.cast((List)((List)map.get("tags")));
        if (tagsProp != null) {
            for (Map map2 : tagsProp) {
                tags.add((String)map2.get("name"));
            }
        } else {
            tags.add("");
        }
        for (String string : tags) {
            userOpsMap.put(string, new LinkedList());
        }
        Map paths = CastUtils.cast((Map)((Map)map.get("paths")));
        for (Map.Entry entry2 : paths.entrySet()) {
            String operPath = (String)entry2.getKey();
            Map operations = (Map)entry2.getValue();
            for (Map.Entry operEntry : operations.entrySet()) {
                List<String> opTags;
                Map payloads;
                UserOperation userOp = new UserOperation();
                userOp.setVerb(((String)operEntry.getKey()).toUpperCase());
                Map oper = CastUtils.cast((Map)((Map)operEntry.getValue()));
                userOp.setPath(operPath);
                userOp.setName((String)oper.get("operationId"));
                Map responses = CastUtils.cast((Map)((Map)oper.get("responses")));
                if (responses != null) {
                    userOp.setProduces(OpenApiParseUtils.listToString(responses.entrySet().stream().map(entry -> CastUtils.cast((Map)((Map)entry.getValue()))).map(value -> CastUtils.cast((Map)((Map)value.get("content")))).filter(Objects::nonNull).flatMap(content -> content.keySet().stream().map(type -> (String)type)).collect(Collectors.toList())));
                }
                if ((payloads = CastUtils.cast((Map)((Map)oper.get("requestBody")))) != null) {
                    userOp.setConsumes(OpenApiParseUtils.listToString(payloads.entrySet().stream().map(entry -> CastUtils.cast((Map)((Map)entry.getValue()))).map(value -> CastUtils.cast((Map)((Map)value.get("content")))).filter(Objects::nonNull).flatMap(content -> content.keySet().stream().map(type -> (String)type)).collect(Collectors.toList())));
                }
                LinkedList<Parameter> userOpParams = new LinkedList<Parameter>();
                List params = CastUtils.cast((List)((List)oper.get("parameters")));
                if (params != null) {
                    for (Map param : params) {
                        String name = (String)param.get("name");
                        String paramType = (String)param.get("in");
                        ParameterType pType = null;
                        pType = "query".equals(paramType) ? ParameterType.QUERY : ("header".equals(paramType) ? ParameterType.HEADER : ("path".equals(paramType) ? ParameterType.PATH : ("cookie".equals(paramType) ? ParameterType.COOKIE : ParameterType.REQUEST_BODY)));
                        Parameter userParam = new Parameter(pType, name);
                        OpenApiParseUtils.setJavaType(userParam, (String)param.get("type"));
                        userOpParams.add(userParam);
                    }
                }
                if (!userOpParams.isEmpty()) {
                    userOp.setParameters(userOpParams);
                }
                if ((opTags = CastUtils.cast((List)((List)oper.get("tags")))) == null) {
                    opTags = Collections.singletonList("");
                }
                for (String opTag : opTags) {
                    ((List)userOpsMap.get(opTag)).add(userOp);
                }
            }
        }
        LinkedList<UserResource> linkedList = new LinkedList<UserResource>();
        for (Map.Entry entry2 : userOpsMap.entrySet()) {
            UserResource ur = new UserResource();
            ur.setPath("/");
            ur.setOperations((List)entry2.getValue());
            ur.setName((String)entry2.getKey());
            linkedList.add(ur);
        }
        app.setResources(linkedList);
        return app;
    }

    private static void setJavaType(Parameter userParam, String typeName) {
        Class javaType = OPENAPI_TYPE_MAP.get(typeName);
        if (javaType == null) {
            try {
                javaType = ClassLoaderUtils.loadClass((String)typeName, OpenApiParseUtils.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        userParam.setJavaType(javaType);
    }

    private static String listToString(List<String> list) {
        if (list != null) {
            StringBuilder sb = new StringBuilder();
            for (String s : list) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(s);
            }
            return sb.toString();
        }
        return null;
    }

    static {
        OPENAPI_TYPE_MAP.put("string", String.class);
        OPENAPI_TYPE_MAP.put("integer", Integer.TYPE);
        OPENAPI_TYPE_MAP.put("float", Float.TYPE);
        OPENAPI_TYPE_MAP.put("double", Double.TYPE);
        OPENAPI_TYPE_MAP.put("int", Integer.TYPE);
        OPENAPI_TYPE_MAP.put("long", Long.TYPE);
        OPENAPI_TYPE_MAP.put("byte", Byte.TYPE);
        OPENAPI_TYPE_MAP.put("boolean", Boolean.TYPE);
        OPENAPI_TYPE_MAP.put("date", Date.class);
        OPENAPI_TYPE_MAP.put("dateTime", Date.class);
        OPENAPI_TYPE_MAP.put("password", String.class);
        OPENAPI_TYPE_MAP.put("binary", InputStream.class);
    }
}

